/**
 * 孵化器 季度任务  主要逻辑
 * 作者:lxm
 */

import moment = require("moment");
import { getLastQuarter, getQuarterTaskId, getQuarterTaskIdByTime, getQuarterTimeKey, getTaskId, getTaskIdByTime, getTimeKey } from "../../../../tools/system";
import * as quarterTaskData from "../../../../data/fuHuaQi/quarterTask/quarterTask";
import * as businessData from "../../../../data/fuHuaQi/quarterTask/businessData";
import { findAllNotDisabledFuHuaQi } from "../../../../data/fuHuaQi/fuhuaqi";
import { QUARTERTASKTYPEENUM } from "../../../../config/enum";
import { logHandle } from "../../../../util/log";
import { createBusinessToList } from "../../../../data/fuHuaQi/quarterTask/businessData";
import { ERRORENUM } from "../../../../config/errorEnum";
import { BizError } from "../../../../util/bizError";

/**
 * 当前月是不是数据填报月
 * @returns true = 是
 */
function isInTime() {
    let thisMonth = new Date().getMonth() + 1;
    let tipsMonth = [1, 4, 7, 10];
    return tipsMonth.indexOf(thisMonth) > -1
}

export async function fuHuaQiQuarterTaskList(uscc:string) {
    /**得到这个月的任务map  taskMap格式为{type:{isSubmit}} */
    const TaskId = getQuarterTaskId(uscc);

    let taskMap = await quarterTaskData.findQuarterTaskMapTypeIsKeyByParam(TaskId);

    let result = [];
    for (let key in QUARTERTASKTYPEENUM) {
        let anyKey:any = key;
        /** 当key是枚举的键的时候 进入到逻辑  */
        if (isNaN(anyKey)) { 
            const ValueStr = QUARTERTASKTYPEENUM[key];//字符型的枚举值 也就是 "4"
            const ValueNumber = parseInt(ValueStr);//number型的枚举值 也就是 4
            let onceObj = { 
                key:ValueNumber, 
                title:anyKey, //标题
                month:'',//由于方便前端直接判断 quarter 改成了 month
                list:[] //相关的列表 这里不应该用这个字段名称 当时不能修改前端 沿用了这个字段名称
            };

            /**没有提交任务 则获取本月提交的任务相关信息 */
            if (taskMap[ValueStr] && !taskMap[ValueStr].isSubmit) {
                let dataList = [];
                onceObj.month =  `第${taskMap[ValueStr].quarter}季度`;
                switch(ValueNumber) {
                    case QUARTERTASKTYPEENUM.孵化器经营状况: 
                        /** 这里加限制  在月度任务中 isUpdate=true代表已经修改  isUpdate=false表示没有这个任务 */
                        dataList = await businessData.findBusinessListByTaskIdAndUpdate(TaskId, true); 
                    break;
                }
            
                dataList.forEach(info => {
                    let addInfo:any = {name:info.name, id:info.uscc};
                    onceObj.list.push(addInfo);
                });
                result.push(onceObj);
            }
        } 
    }
   
    return {taskList:result};
}


/**
 * 孵化器 季度任务 已办任务列表
 * 小程序端  3.1
 * 只显示selectTime月分的 已经办理的任务
 * @param uscc 孵化器统一信用
 * @returns [{type:1, title:'', enterpriseList:[] }]
 */
export async function fuHuaQiQuarterCompletedTaskList(uscc:string, selectTime:number) {
    /**得到查询月的任务map  taskMap格式为{type:{isSubmit}} */
    const TaskId = getQuarterTaskIdByTime(uscc, selectTime);

    let editable = getTaskId(uscc) == TaskId && isInTime();//如果是本季度，并且在数据填报月 就是可以编辑的

    let taskMap = await quarterTaskData.findQuarterTaskMapTypeIsKeyByParam(TaskId);
    
    let result = [];
    for (let key in QUARTERTASKTYPEENUM) {
        let anyKey:any = key;
        /** 当key是枚举的键的时候 进入到逻辑  */
        if (isNaN(anyKey)) { 
            const ValueStr = QUARTERTASKTYPEENUM[key];//字符型的枚举值 也就是 "1"或者"2"或者"3"
            const ValueNumber = parseInt(ValueStr);//number型的枚举值 也就是 1或者2或者3
            let onceObj:any = { 
                key:ValueNumber, 
                title:anyKey, //标题
                editable,
                list:[] //相关的列表 
            };

             /**当选中了系统上线时间前的时间 任务不存在 就是空列表 */
             if (!taskMap[ValueStr]) continue;

            /**获取提交的任务 */
            if ( taskMap[ValueStr].isSubmit ) {
                onceObj.month =  `第${taskMap[ValueStr].quarter}季度`;
                let dataList = [];

                switch(ValueNumber) {
                    case QUARTERTASKTYPEENUM.孵化器经营状况: 
                        /** 这里加限制  在月度任务中 isUpdate=true代表已经修改  isUpdate=false表示没有这个任务 */
                        dataList = await businessData.findBusinessListByTaskIdAndUpdate(TaskId, true); 
                    break;
                } 
            
                dataList.forEach(info => {
                    let addInfo:any = {name:info.name, id:info.uscc, editable };
                    onceObj.enterpriseList.push(addInfo);
                });
                result.push(onceObj);
            }
        } 
    }

    return {taskList:result};
}



/**
 * 孵化器 过期任务列表
 * 小程序端 2.0
 * 只显示selectTime月份的 过期任务
 * @param uscc 孵化器统一信用
 * @returns [{type:1, title:'', enterpriseList:[] }]
 */
export async function fuHuaQiQuarterPastdueTaskList(uscc:string, selectTime:number) {
    /**得到查询月的任务map  taskMap格式为{type:{isSubmit}} */
    if (selectTime >= new Date().valueOf() ) return {taskList:[]};

    const TaskId = getQuarterTaskIdByTime(uscc, selectTime);
    let taskMap = await quarterTaskData.findQuarterTaskMapTypeIsKeyByParam(TaskId);
    
    let result = [];
    for (let key in QUARTERTASKTYPEENUM) {
        let anyKey:any = key;
        /** 当key是枚举的键的时候 进入到逻辑  */
        if (isNaN(anyKey)) { 
            const ValueStr = QUARTERTASKTYPEENUM[key];//字符型的枚举值 也就是 "4"
            const ValueNumber = parseInt(ValueStr);//number型的枚举值 也就是 4
            let onceObj:any = { 
                key:ValueNumber, 
                title:anyKey, //标题
                list:[] //相关的列表 这里不应该用这个字段名称 当时不能修改前端 沿用了这个字段名称
            };

            /**当选中了系统上线时间前的时间 任务不存在 就是空列表 */
            if (!taskMap[ValueStr]) continue;

            /**未提交的数据 */
            if (!taskMap[ValueStr].isSubmit) {
                onceObj.month =  `第${taskMap[ValueStr].quarter}季度`;
                result.push(onceObj);
            }
        } 
    }

    return {taskList:result};
}


/**
 * 提交 季度任务
 * 小程序端
 * @param uscc 孵化器统一信用代码
 * @param taskType 任务类型
 * @returns {isSuccess:true/false}
 */
export async function checkTask(uscc:string, taskType:number) {
    const TaskId = getTaskId(uscc);
    let taskInfo = await quarterTaskData.findQuarterTaskByTaskIdAndType(TaskId, taskType);;
    
    /**提交限制 */
    if (!taskInfo) throw new BizError(ERRORENUM.任务不存在, uscc, TaskId);
    if ( taskInfo.isSubmit ) throw new BizError(ERRORENUM.不能重复提交任务, uscc, taskType);

    let submitCount = 0;
    switch (taskType) {
        case QUARTERTASKTYPEENUM.孵化器经营状况:
            /**月度报表每个月初和任务数据一起初始化 所以只需要修改状态  */
            let monthTableInfo = await  businessData.findBusinessByTaskId(TaskId);
            if (!monthTableInfo.isUpdate) throw new BizError(ERRORENUM.该报表需要填写本季度内容后提交, uscc, taskType);
            if ( monthTableInfo.draftLock ) throw new BizError(ERRORENUM.不能重复提交任务, uscc, taskType, '孵化器经营数据表lock = true');
            
            monthTableInfo.draftLock = true;
            monthTableInfo.submitTime = new Date().valueOf();
            await monthTableInfo.save();

        break;
       
    }

    /** 修改任务状态标识 和相关信息 */
    taskInfo.isSubmit = true;
    taskInfo.submitTime = new Date().valueOf();
    taskInfo.submitCount = submitCount;
    
    await taskInfo.save();

    return {isSuccess:true};
}


/**
 * 发放任务
 * 系统自发
 * 下发任务的同时初始化月度报表数据
 */
export async function provideFuHuaQiQuarterTask() {
    //不是数据填报月不下发任务
    if (!isInTime()) return;

    let {year, quarter} = getLastQuarter();
    let count = await quarterTaskData.findQuarterTaskCountByParam({year, quarter});
    if (count) return;//不能重复发放任务

    let addList = [];//任务列表
    let businessDataList = [];//经营数据
    let key = getQuarterTimeKey();

    let fuHuaQiList = await findAllNotDisabledFuHuaQi();
    fuHuaQiList.forEach(info => {
        let { uscc } = info;
        let taskId = getQuarterTaskId(uscc);
        addList.push({
            key,  type:QUARTERTASKTYPEENUM.孵化器经营状况, 
            taskId, fuHuaQiUscc:uscc, submitTime:0, isSubmit:false,  
            quarter,  year, submitCount:0
        });
        /**任务报表的初始状态为 草稿(draftLock=fals) 未被编辑(isUpdate=false)  */
        businessDataList.push({ 
            taskId, quarter, year,
            name:`孵化器第${quarter}季度填报`,
            fuHuaQiUscc:uscc,
            TR:0, ROR:0, RR:0, FS:0, MIS:0, NP:0, TP:0,
            draftLock:false, isUpdate:false, submitTime:0
        });
    });

    try {
        /**初始化 孵化器季度任务 */
        await quarterTaskData.createQuarterTaskToList(addList);
        logHandle(`添加了${addList.length} 任务`);
        /**初始化 经营数据报表 */
        await createBusinessToList(businessDataList);
        logHandle(`添加了${businessDataList.length} 月度任务`);
    } catch (err) {
        new BizError(ERRORENUM.系统错误, '添加任务和月度报表的时候 出现了异常 请检查数据库  ', err);
    }

}


/**
 * 回收任务分数
 * 将回收月上一个月下发的数据进行状态回收 回收月与下发月永远会在同一个季度
 */
export async function retrieveMonthTask() {
    /**回收本季度数据 */
    //todo  这里没有涉及积分 不需要做处理  留好坑
}