/**
 * 张江以外布局 逻辑
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as zjBeyondLayoutData  from "../../../../data/fuHuaQi/instituQualify/zjBeyondLayout";


export async function createZJBeyondLayout(uscc:string, city:string, area:number, operationMode:number) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await zjBeyondLayoutData.addData(id, uscc, fuHuaQiInfo.name, city, area, operationMode);
    
    return {isSuccess:true};
}



export async function updateZJBeyondLayout(uscc:string, id:string, city:string, area:number, operationMode:number) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    dataInfo.city = city; 
    dataInfo.area = area; 
    dataInfo.operationMode = operationMode; 

    await dataInfo.save();

    return {isSuccess:true};
}


export async function selectZJBeyondLayout(id:string) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    let layoutData = {
        city:dataInfo.city,
        area:dataInfo.area,
        operationMode:dataInfo.operationMode
    };

    return {layoutData} 
}

export async function deleteZJBeyondLayout(id:string) {
    await zjBeyondLayoutData.deleteDataById(id);

    return {isSuccess:true} 
}

export async function getZJBeyondLayoutListData(uscc:string) {
    let registerList = await zjBeyondLayoutData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            city:info.city,
            area:info.area,
            operationMode:info.operationMode
        });
    });

    return {dataList, title:"张江以外布局情况"}
}
