/**
 * 创业导师 逻辑
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as startupTeacherData  from "../../../../data/fuHuaQi/instituQualify/startupTeacher";


export async function createStartUpTeacher(uscc:string, teacherName:string, unit:string, duties:string, speciality, teacherLv:number, serviceEnterprises:string) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await startupTeacherData.addData(id, uscc, fuHuaQiInfo.name, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises);
    
    return {isSuccess:true};
}



export async function updateStartUpTeacher(uscc:string, id:string, teacherName:string, unit:string, duties:string, speciality, teacherLv:number, serviceEnterprises:string) {
    let dataInfo = await startupTeacherData.findOneData(id);

    dataInfo.teacherName = teacherName; 
    dataInfo.unit = unit; 
    dataInfo.duties = duties; 
    dataInfo.speciality = speciality; 
    dataInfo.teacherLv = teacherLv; 
    dataInfo.serviceEnterprises = serviceEnterprises;

    await dataInfo.save();

    return {isSuccess:true};
}


export async function selectStartUpTeacher(id:string) {
    let dataInfo = await startupTeacherData.findOneData(id);

    let startUpData = {
        teacherName:dataInfo.teacherName,
        unit:dataInfo.unit,
        duties:dataInfo.duties,
        speciality:dataInfo.speciality,
        teacherLv:dataInfo.teacherLv,
        serviceEnterprises:dataInfo.serviceEnterprises,
    };

    return {startUpData} 
}

export async function deleteStartUpTeacher(id:string) {
    await startupTeacherData.deleteDataById(id);

    return {isSuccess:true} 
}

export async function getStartUpTeacherListData(uscc) {
    let registerList = await startupTeacherData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            teacherName:info.teacherName,
            unit:info.unit,
            duties:info.duties,
            speciality:info.speciality,
            teacherLv:info.teacherLv,
            serviceEnterprises:info.serviceEnterprises,
        });
    });

    return {dataList, title:"创业导师情况"}
}
