import * as i18nRegisterData from "../../../../data/fuHuaQi/instituQualify/i18nRegister";
import * as icrData from "../../../../data/fuHuaQi/instituQualify/icr";
import * as startupTeacherData from "../../../../data/fuHuaQi/instituQualify/startupTeacher";
import * as zjBeyondLayoutData from "../../../../data/fuHuaQi/instituQualify/zjBeyondLayout";
import { STATEENUM } from "../../../../config/enum";
import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";

/**
 * 修改创投基金登记信息
 * @param uscc 
 * @param isCreatePTP 
 * @param scalePTP 
 * @param isParticipateInPTP 
 */
export async function updatePTPInfo(uscc:string, isCreatePTP:boolean, scalePTP:number, isParticipateInPTP:boolean, participatingFundCompany:string) {
    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    fuHuaQiInfo.isCreatePTP = isCreatePTP;
    fuHuaQiInfo.scalePTP = scalePTP;
    fuHuaQiInfo.isParticipateInPTP = isParticipateInPTP;
    fuHuaQiInfo.participatingFundCompany = participatingFundCompany,

    await fuHuaQiInfo.save();

    return {isSuccess:true};
}


export async function getFuHuaQiPTP(uscc:string) {
    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let PTPInfo = {
        isCreatePTP:fuHuaQiInfo.isCreatePTP,
        scalePTP:fuHuaQiInfo.scalePTP,
        isParticipateInPTP:fuHuaQiInfo.isParticipateInPTP,
        participatingFundCompany:fuHuaQiInfo.participatingFundCompany,
    };

    return {PTPInfo};
}


export async function updateProfessionalTechnology(uscc:string, isProfessionalTechnology:boolean, professionalTechnologyName:String, 
    professionalTechnologyCreateTime:number, professionalTechnologyAmount:number, isCooperation:boolean, cooperationInstitutions:string) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    fuHuaQiInfo.isProfessionalTechnology= isProfessionalTechnology;//是否专业技术平台
    fuHuaQiInfo.professionalTechnologyName= professionalTechnologyName;//专业技术平台名称
    fuHuaQiInfo.professionalTechnologyCreateTime= professionalTechnologyCreateTime;//时间  年份 xxxx年01月01日 的时间戳
    fuHuaQiInfo.professionalTechnologyAmount= professionalTechnologyAmount;//投资金额万元
    fuHuaQiInfo.isCooperation= isCooperation;//是否与第三方合作
    fuHuaQiInfo.cooperationInstitutions= cooperationInstitutions;//合作机构名称

    await fuHuaQiInfo.save();

    return {isSuccess:true};
}


export async function getProfessionalTechnology(uscc:string) {
    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let professionalTechnologyInfo = {
        isProfessionalTechnology:fuHuaQiInfo.isProfessionalTechnology,
        professionalTechnologyName:fuHuaQiInfo.professionalTechnologyName,
        professionalTechnologyCreateTime:fuHuaQiInfo.professionalTechnologyCreateTime,
        professionalTechnologyAmount:fuHuaQiInfo.professionalTechnologyAmount,
        isCooperation:fuHuaQiInfo.isCooperation,
        cooperationInstitutions:fuHuaQiInfo.cooperationInstitutions,
    };

    return { professionalTechnologyInfo };
}


export async function overview(uscc:string) {
    let i18n = await i18nRegisterData.getCount(uscc);
    let icr = await icrData.getCount(uscc);
    let startupteacher = await startupTeacherData.getCount(uscc);
    let zjbeyondlayout = await zjBeyondLayoutData.getCount(uscc);
    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    let data = {
        i18n,
        icr,
        startupteacher,
        zjbeyondlayout,
        isCreatePTP:fuHuaQiInfo.isCreatePTP != STATEENUM.未选,
        isProfessionalTechnology:fuHuaQiInfo.isProfessionalTechnology != STATEENUM.未选
    };

    return data;
}

