/**
 * 大学/科研院所合作机构 逻辑
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as icrData  from "../../../../data/fuHuaQi/instituQualify/icr";


export async function createIcr(uscc:string, po:string, ce:string, cMode, cAchievements:string, startTimeMs:number) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await icrData.addData(id, uscc, fuHuaQiInfo.name, po, ce, cMode, cAchievements, startTimeMs);
    
    return {isSuccess:true};
}


export async function updateIcr(uscc:string, id:string, po:string, ce:string, cMode, cAchievements:string, startTimeMs:number) {
    let dataInfo = await icrData.findOneData(id);

    dataInfo.po = po;
    dataInfo.ce = ce;
    dataInfo.cMode = cMode;
    dataInfo.cAchievements = cAchievements;
    dataInfo.startTimeMs = startTimeMs;

    await dataInfo.save();

    return {isSuccess:true};
}


export async function selectIcr(id:string) {
    let dataInfo = await icrData.findOneData(id);

    let startUpData = {
        po:dataInfo.po,
        ce:dataInfo.ce,
        cMode:dataInfo.cMode,
        cAchievements:dataInfo.cAchievements,
        startTimeMs:dataInfo.startTimeMs,
    };

    return {startUpData} 
}

export async function deleteIcr(id:string) {
    await icrData.deleteDataById(id);

    return {isSuccess:true} 
}

export async function getIcrListData(uscc) {
    let registerList = await icrData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            po:info.po,
            ce:info.ce,
            cMode:info.cMode,
            cAchievements:info.cAchievements,
            startTimeMs:info.startTimeMs,
        });
    });

    return {dataList, title:"大学/科研院所合作机构"}
}
