
/**  
 * 孵化器 机构资质
 *  
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getI18nRegisterId } from "../../../../tools/system";
import { addRegister, deleteI18nRegisterListById, findI18nRegisterListByParam, findOneI18nRegister, getCount } from "../../../../data/fuHuaQi/instituQualify/i18nRegister";




/**
 * 创建国际化登记
 * @param uscc 企业统一信用代码
 * @param country 国家
 * @param partners 合作机构
 * @param cMode 合作方式
 * @param cAchievements 合作成果
 * @returns 
 */
export async function createI18nRegister(uscc:string, country:string, partners:string, cMode:string, cAchievements:string) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getI18nRegisterId(uscc);
    await addRegister(id, uscc, fuHuaQiInfo.name, country, partners, cMode, cAchievements);
    
    return {isSuccess:true};
}


/**
 * 修改国际化登记
 * @param uscc 企业统一信用代码
 * @param id 标识
 * @param country 国家
 * @param partners 合作机构
 * @param cMode 合作方式
 * @param cAchievements 合作成果
 * @returns 
 */
export async function updateI18nRegister(uscc:string, id:string, country:string, partners:string, cMode:string, cAchievements:string) {
    let registerInfo = await findOneI18nRegister(id);

    registerInfo.country = country;
    registerInfo.partners = partners;
    registerInfo.cMode = cMode;
    registerInfo.cAchievements = cAchievements;

    await registerInfo.save();

    return {isSuccess:true};
}


export async function selectI18nRegisterInfo(id:string) {
    let registerInfo = await findOneI18nRegister(id);

    let registerData = {
        country : registerInfo.country,
        partners : registerInfo.partners,
        cMode : registerInfo.cMode,
        cAchievements : registerInfo.cAchievements,
    };

    return {registerData} 
}

export async function deleteI18nRegisterInfo(id:string) {
    await deleteI18nRegisterListById(id);

    return {isSuccess:true} 
}

export async function i18nRegisterListData(uscc) {
    let registerList = await findI18nRegisterListByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            country:info.country,
            partners:info.partners,
            cMode:info.cMode,
            cAchievements:info.cAchievements,
        });
    });

    return {dataList, title:"国际化登记"}
}

