/**
 * 政策速递 企业端
 */

import moment = require("moment");
import { selectInformationByParam, selectInformationByParamCount, selectInformationByParamToPage, selectInformationDataById, selectOnceInformationByParamToParam } from "../../data/guanWeiHui/information";




/**
 * 获取资讯列表
 * 
 * @param uscc 预留好 后期做推荐的参数
 * @param selectTitle 
 * @param page 分页
 * @returns 
 */
export async function getInformationList(uscc:string, selectTitle:string, page:number) {
    let selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    let informationList = await selectInformationByParamToPage(selectParam, (page-1) * 10 );
    let count = await selectInformationByParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;

    let dataList = [];

    informationList.forEach((info) => {
        let { id, title,createTimeMs, source, coverImg } = info;
        
        dataList.push({title, id, createTime:moment(createTimeMs).format("MM/DD"),source, url:`/policy/${coverImg}`});
        
    });

    return {dataList, count, pageCount};
}


/**
 * 获取过期资讯列表
 * 
 * @param uscc 预留好 后期做推荐的参数
 * @param selectTitle 模糊查询标题
 * @param page 分页
 * @returns 
 */
export async function getOutOfDateInformationList(uscc:string, selectTitle:string, page:number) {
    let selectParam = {"$or":[{closeTimeMs: {"$lt":new Date().valueOf()} }, {state:false}] };
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    let informationList = await selectInformationByParamToPage(selectParam, (page-1) * 10 );
    let count = await selectInformationByParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;
    let dataList = [];

    informationList.forEach((info) => {
        let { id, title,createTimeMs, source, coverImg } = info;
        
        dataList.push({title, id, createTime:moment(createTimeMs).format("MM/DD"), source, url:`/policy/${coverImg}`});
        
    });

    return {dataList, count, pageCount};
}


/**
 * 获取资讯详情
 * @param uscc 
 * @param id 标识
 */
export async function getOnceinformation(uscc:string, id:string) {
    let informationData = await selectInformationDataById(id );

    let reuslt = {
        title:informationData.title,
        desc:informationData.desc,
        source:informationData.source,
        createTime:moment(informationData.createTimeMs).format("MM/DD")
    };

    return {infomation:reuslt};
}


export async function getInformationTitleList() {
    let selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
    let informationData = await selectOnceInformationByParamToParam(selectParam);

   
    return {title:informationData.title};
}