/**
 * 创始团队主要逻辑
 * 作者：lxm
 */

import { EnterpriseQualificationUpdateConfig, EnterpriseUpdateBaseDataConfig, InitialTeamUpdateConfig } from "../../../config/eccFormParamConfig";
import { ENTERPRISETEAM, INDUSTRY, LISTINGSITUATION, STATEENUM } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { EnterpriseBaseConfig, EnterpriseInitialTeamConfig } from "../../../config/splitResultConfig";
import * as enterpriseData from "../../../data/enterprise/enterprise";
import { addMoneyEnterpriseInitialTeam, deleteMoneyEnterpriseInitialTeam, findEnterpriseInitialTeam, updateMoneyEnterpriseInitialTeam } from "../../../data/enterprise/initialTeam";
import { findEnterpriseNewTeamData } from "../../../data/enterprise/quarterTask/team";
import { getInitialTeamMemberId } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { checkChange, checkDataHaveNull, extractData } from "../../../util/piecemeal";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";

/**
 * 修改创始团队信息
 * 修改 删除 添加  为一个接口 根据数据情况与老数据情况做匹配
 * @param uscc 企业统一信用代码
 * @param firstClassTalent 是否拥有国际一流人才
 * @param teams 创始团队信息
 * @returns isSuccess
 */
export async function updateInitialTeamInfo(uscc:string, firstClassTalent:number, teams) {
    eccEnumValue("修改创始团队信息", "firstClassTalent", STATEENUM, firstClassTalent);
    if (firstClassTalent==STATEENUM.未选) throw new BizError(ERRORENUM.请先选择是否拥有, '修改创始团队信息 没有选是和否');
    /**校验参数 */
    if ( (firstClassTalent==STATEENUM.是 && !Array.isArray(teams)) || (firstClassTalent==STATEENUM.是 && !teams.length) ) {
        throw new BizError(ERRORENUM.参数错误, "修改创始团队信息", "缺少参数 teams");
    }
    if (!firstClassTalent) teams = [];

    teams.forEach((info, index) => {
        eccFormParam(`修改创始团队信息 下标:${index}`, InitialTeamUpdateConfig, info);
        eccEnumValue('修改创始团队信息', 'type', ENTERPRISETEAM, info.type);
        if (info.des.length > 200) throw new BizError(ERRORENUM.字数超过200限制, `修改创始团队信息 下标:${index}`);
    });

    //是否拥有国际人才这个字段在 企业表中 需要单独做更改
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    enterpriseInfo.haveFirstClassTalent = firstClassTalent;
    await enterpriseInfo.save();

    let enterpriseInitialTeamList = await findEnterpriseInitialTeam(uscc);
    
    /**匹配数据操作逻辑 */
    let newTeamIdList = [];//用于匹配新数据，老数据不在新数据中 判定为被删除
    teams.forEach(info => {
        if (info.id && info.id != "newdata") newTeamIdList.push(info.id);//todo
    });
    let deleteList = [];
    //老数据将出现在这个map里 用于与新数据id匹配，匹配id不在老数据中判定为添加操作
    let dataBaseTeamMap = {}; 
    enterpriseInitialTeamList.forEach(info => {
        dataBaseTeamMap[info.id] = info;
        if (newTeamIdList.indexOf(info.id) == -1 ) {
            deleteList.push(info);
        } 
    });

    let addList = [];
    let updateList = [];

    teams.forEach(info => {
        let {id} = info;
        let dataBaseInfo = dataBaseTeamMap[id]; 
        if (!dataBaseInfo) {//不存在老的id 判定为添加操作
            info.id = getInitialTeamMemberId(uscc, info.name);
            info.uscc = uscc;
            info.name = enterpriseInfo.name;
            addList.push(info);
        } else {
            //比对新老数据判断数据需不需要修改
            let changeList = checkChange(info, Object.assign({name:enterpriseInfo.name, uscc}, dataBaseInfo));
            if (changeList.length) updateList.push(info);
        }
    });

    /**修改数据 */
    if (addList.length) await addMoneyEnterpriseInitialTeam(addList);
    if (updateList.length) await updateMoneyEnterpriseInitialTeam(updateList);
    if (deleteList.length) await deleteMoneyEnterpriseInitialTeam(deleteList);

    return {isSuccess:true};
}


/**
 * 获取创始团队信息
 * 回显
 * @param uscc 企业统一信用代码
 * @returns initialTeam 团队列表  firstClassTalent 是否拥有国际一流人才
 */
export async function selectInitialTeamInfo(uscc:string) {
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    let firstClassTalent = enterpriseInfo.haveFirstClassTalent || STATEENUM.未选;

    let initialTeamList = await findEnterpriseInitialTeam(uscc);

    let initialTeam = [];

    initialTeamList.forEach(info => {
        let changeData = extractData(EnterpriseInitialTeamConfig, info, false);
        initialTeam.push(changeData);
    });
    
    return { initialTeam, firstClassTalent }; 
}