/**
 * 资讯逻辑
 */

import moment = require("moment");
import { ERRORENUM } from "../../config/errorEnum";
import { createInformation, deleteInformationData, selectInformationByParam, selectInformationByParamCount, selectInformationByParamToPage, selectInformationDataById } from "../../data/guanWeiHui/information";
import { getInformationId } from "../../tools/system";
import { BizError } from "../../util/bizError";


export async function addOnceInformation(desc:string, title:string ,source:string, coverImg:string ) {
    let id = getInformationId();
    await createInformation(id, desc, title, source, coverImg);

    return {isSuccess:true};
}


export async function openInformation(id:string, isPermanent:boolean, closeTimeMs:number) {
    if ( isPermanent ) closeTimeMs = 0;
    else {
        if (!closeTimeMs) throw new BizError(ERRORENUM.参数错误, "开启任务时 缺少创建时间");
    }

    let informationData = await selectInformationDataById(id);
    if (informationData.state) throw new BizError(ERRORENUM.请不要重复开启资讯);

    informationData.isPermanent = isPermanent;
    informationData.closeTimeMs = closeTimeMs;
    informationData.state = true;

    await informationData.save();

    return {isSuccess:true};
}


export async function closeInformation(id:string) {
    let informationData = await selectInformationDataById(id);

    informationData.state = false;
    await informationData.save();

    return {isSuccess:true};
}


export async function selectOnceInformationDate(id:string) {
    let onceDataInfo = await selectInformationDataById(id);

    let result = {
        id:onceDataInfo.id,
        title:onceDataInfo.title,
        desc:onceDataInfo.desc,
        source:onceDataInfo.source,
        coverImg:onceDataInfo.coverImg,
        url:`/policy/${onceDataInfo.coverImg}`,
    };


    return {dataInfo:result};
}



export async function deleteOnceInformationDate(id:string) {
    let onceDataInfo = await selectInformationDataById(id);

    if (onceDataInfo.state) throw new BizError(ERRORENUM.请先关闭该资讯, "未关闭资讯进行删除操作");

    await deleteInformationData(id);

    return {isSuccess:true};
}


export async function updateOnceInformation(id:string, desc:string, title:string ,source:string, coverImg:string ) {
    let onceDataInfo = await selectInformationDataById(id);

    if (onceDataInfo.state) throw new BizError(ERRORENUM.请先关闭该资讯, "未关闭资讯进行修改操作");

    onceDataInfo.coverImg = coverImg;
    onceDataInfo.title = title;
    onceDataInfo.desc = desc;
    onceDataInfo.source = source;

    await onceDataInfo.save();

    return {isSuccess:true};
}


export async function selectInformation(selectTitle:string, createTime:number, state:number, page:number) {

    let selectParam = {};
    if (state == 2 || state == 3) {
        if (state == 2) {
            selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
        } else {
            selectParam = {"$or":[{closeTimeMs: {"$lt":new Date().valueOf()} }, {state:false}] };
        }
    }
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    if (createTime) {
        selectParam["$and"] = [{"createTimeMs":{"$gt":createTime }}, {"createTimeMs":{"$lt":createTime+(3600*26*1000) }}]
    }

    let dataBaseList = await selectInformationByParamToPage(selectParam, (page-1)* 10);
    let count = await selectInformationByParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;

    let dataList = [];
    dataBaseList.forEach(info => {
        let {title, createTimeMs, state, closeTimeMs, isPermanent, id} = info;
        let stateStr = "下线";
        if (state) {
            stateStr = "上线";
            if (!isPermanent && closeTimeMs< new Date().valueOf()) stateStr = "下线";
        }

        dataList.push({
            id,
            title,
            createTime:moment(createTimeMs).format("YYYY-MM-DD"),
            state,
            stateStr
        });
    });

    return {dataList, pageCount, count};
}
