/**
 * 公共资源路由
 */

import * as asyncHandler from 'express-async-handler';
import { FUHUAQILV, INSTITUTIONALNATURE, FUHUAINDUSTRY, INDUSTRY, FUHUAQILNVESTMENTSTYLE, OPERATIONMODEL, TEAM, DEGREE, FINANCINGROUNDS, INSIDESTATE, VIRTUALCAUSE, MOVEOUTTYPE, MOVEOUTCAUSE, MOVEOUTCAUSECLIENT, MOVEOUTCAUSENOTCLIENT, MOVEOUTTRACE, ENTERPRISETEAM, LISTINGSITUATION, BUSINESSDATATYPE, COOPERATIONMODE, SPECIALITY, TEACHERLV, ZJBEYONDLAYOUTOPERATIONMODE } from '../config/enum';

export function setRouter(httpServer) {
    httpServer.post('/public/fuhuaqilv', asyncHandler(getFuHuaQiLv));
    httpServer.post('/public/institutionalnature', asyncHandler(getInstitutionalNature));
    httpServer.post('/public/fuhuaqiindustry', asyncHandler(getFuHuaQiIndustry));
    httpServer.post('/public/industry', asyncHandler(getIndustry));
    httpServer.post('/public/investmentstyle', asyncHandler(getFuHuaQiInvestmentStyle));
    httpServer.post('/public/operationmodel', asyncHandler(operationModel));
    httpServer.post('/public/fuhuaqiteam', asyncHandler(fuHuaQiTeam));
    httpServer.post('/public/degree', asyncHandler(degree));
    httpServer.post('/public/financingrounds', asyncHandler(financingRounds));
    /**2.0 */
    httpServer.post('/public/insidestate', asyncHandler(insidestate));
    httpServer.post('/public/virtualcause', asyncHandler(virtualCause));
    httpServer.post('/public/moveouttype', asyncHandler(moveOutType));
    httpServer.post('/public/moveoutcause', asyncHandler(moveOutCause));
    /**2.1 */
    httpServer.post('/public/graduatecause', asyncHandler(graduateCauseType));
    /**2.3 */
    httpServer.post('/public/moveouttrace', asyncHandler(moveOutTrace) );
    /**3.0 */
    httpServer.post('/public/enterpriseteam', asyncHandler(initTeam) );
    httpServer.post('/public/listingsituation', asyncHandler(listingSituation) );
    httpServer.post('/public/businessdatatype', asyncHandler(businessDataType) );
    /**3.1 */
    httpServer.post('/public/cooperationmode', asyncHandler(cooperationMode) );
    httpServer.post('/public/speciality', asyncHandler(speciality) );
    httpServer.post('/public/teacherlv', asyncHandler(teacherLv) );
    httpServer.post('/public/zjbeyondlayoutoperationmode', asyncHandler(zjBeYondLayoutOperationMode) );
    
}

/**
 * 小程序端 合作方式
 * @param req 
 * @param res 
 */
function cooperationMode(req, res) {
    let dataList = [];
    for (let key in COOPERATIONMODE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:COOPERATIONMODE[key]});
        }
    }
    res.success({dataList});
}

/**
 * 小程序端 专业特长
 * @param req 
 * @param res 
 */
function speciality(req, res) {
    let dataList = [];
    for (let key in SPECIALITY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (keyStr == "科技金融_风险投资_" || keyStr == "科技金融_其他_" || keyStr == "技术专家_法律专家_") {
                keyStr = keyStr.replace("_","(");
                keyStr = keyStr.replace("_",")");
            }
            dataList.push({key:keyStr, value:SPECIALITY[key]});
        }
    }
    res.success({dataList});
}

/**
 * 小程序端 导师等级
 * @param req 
 * @param res 
 */
function teacherLv(req, res) {
    let dataList = [];
    for (let key in TEACHERLV) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:TEACHERLV[key]});
        }
    }
    res.success({dataList});
}


/**
 * 小程序端 张江以外布局运营模式
 * @param req 
 * @param res 
 */
function zjBeYondLayoutOperationMode(req, res) {
    let dataList = [];
    for (let key in ZJBEYONDLAYOUTOPERATIONMODE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:ZJBEYONDLAYOUTOPERATIONMODE[key]});
        }
    }
    res.success({dataList});
}


/**
 * 小程序端 经营数据类型
 * @param req 
 * @param res 
 */
function businessDataType(req, res) {
    let dataList = [];
    for (let key in BUSINESSDATATYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:BUSINESSDATATYPE[key]});
        }
    }
    res.success({dataList});
} 


/**
 * 小程序端 上市情况
 * @param req 
 * @param res 
 */
function listingSituation(req, res) {
    let dataList = [];
    for (let key in LISTINGSITUATION) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:LISTINGSITUATION[key]});
        }
    }
    res.success({dataList});
} 



/**
 * 小程序端 企业创始团队
 * @param req 
 * @param res 
 */
function initTeam(req, res) {
    let dataList = [];
    for (let key in ENTERPRISETEAM) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:ENTERPRISETEAM[key]});
        }
    }
    res.success({dataList});
} 



/**
 * 迁出去向
 * @param req 
 * @param res 
 */
function moveOutTrace(req, res) {
    let dataList = [];
    for (let key in MOVEOUTTRACE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (keyStr == "迁出孵化器_仍在张江" || keyStr == "迁出张江_仍在浦东" || keyStr == "迁出浦东_仍在上海") {
                keyStr = keyStr.replace("_",",");
            }
            dataList.push({key:keyStr, value:MOVEOUTTRACE[key]});
        }
    }
    res.success({dataList});
} 


/**
 * 毕业迁出原因
 */
function graduateCauseType(req, res) {
    let dataList = [];
    for (let key in MOVEOUTCAUSECLIENT) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            dataList.push({key:keyStr, value:MOVEOUTCAUSECLIENT[key]});
        }
    }
    res.success({dataList});
}


/**
 * 迁出类型
 */
function moveOutType(req, res) {
    let dataList = [];
    for (let key in MOVEOUTTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (keyStr == "迁出孵化器_仍在张江" || keyStr == "迁出张江_仍在浦东" || keyStr == "迁出浦东_仍在上海") {
                keyStr = keyStr.replace("_",",");
            }
            dataList.push({key:keyStr, value:MOVEOUTTYPE[key]});
        }
        
    }
    res.success({dataList});
}


/**
 * 非毕业迁出原因
 */
function moveOutCause(req, res) {
    let dataList = [];
    for (let key in MOVEOUTCAUSENOTCLIENT) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (keyStr == "经营成本过高_场地成本或人员成本_" || keyStr == "办公空间拓展_无合适办公空间_") {
                keyStr = keyStr.replace("_","(");
                keyStr = keyStr.replace("_",")");
            }

            dataList.push({key:keyStr, value:MOVEOUTCAUSENOTCLIENT[key]});
        }
    }
    res.success({dataList});
}


/**
 * 虚拟孵化模式
 * @param req 
 * @param res 
 */
function virtualCause(req, res) {
    let dataList = [];
    for (let key in VIRTUALCAUSE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            dataList.push({key, value:VIRTUALCAUSE[key]});
        }
    }
    res.success({dataList});
}

/**
 * 入孵状态
 */
function insidestate(req, res) {
    let dataList = [];
    for (let key in INSIDESTATE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            dataList.push({key, value:INSIDESTATE[key]});
        }
    }
    res.success({dataList});
}


/**
 * 融资轮次
 * @param req 
 * @param res 
 */
export function financingRounds(req, res) {
    let financingRoundsList = [];
    for (let key in FINANCINGROUNDS) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            financingRoundsList.push({key, value:FINANCINGROUNDS[key]});
        }
    }
    res.success({financingRoundsList});
}


/**
 * 最高学历
 * @param req 
 * @param res 
 */
export function degree(req, res) {
    let degreeList = [];
    for (let key in DEGREE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            degreeList.push({key, value:DEGREE[key]});
        }
    }
    res.success({degreeList});
}

/**
 * 获取运营模式列表
 * @param req 
 * @param res 
 */
export function operationModel(req, res) {
    let operationModelList = [];
    for (let key in OPERATIONMODEL) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (parseInt(OPERATIONMODEL[key]) == OPERATIONMODEL._投资__孵化_类型) {
                keyStr = keyStr.replace("__","+");
                keyStr = keyStr.replace("_","“");
                keyStr = keyStr.replace("_","”");
            }
            operationModelList.push({key:keyStr, value:OPERATIONMODEL[key]});
        }
    }
    res.success({operationModelList});
}

/**
 * 孵化器创业团队
 * @param req 
 * @param res 
 */
export function fuHuaQiTeam(req, res) {
    let teamList = [];
    for (let key in TEAM) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            teamList.push({key, value:TEAM[key]});
        }
    }
    res.success({teamList});
}


/**
 * 获取孵化器等级列表
 * @param req 
 * @param res 
 */
async function getFuHuaQiLv(req, res) {
    let lvList = [];
    for (let key in FUHUAQILV) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:FUHUAQILV[key]});
        }
    }
    res.success({lvList});
}


/**
 * 获取孵化器机构性质列表
 * @param req 
 * @param res 
 */
async function getInstitutionalNature(req, res) {
    let lvList = [];
    for (let key in INSTITUTIONALNATURE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:INSTITUTIONALNATURE[key]});
        }
    }
    res.success({lvList});
}

/**
 * 获取孵化器领域
 * @param req 
 * @param res 
 */
async function getFuHuaQiIndustry(req, res) {
    let lvList = [];
    for (let key in FUHUAINDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:FUHUAINDUSTRY[key]});
        }
    }
    res.success({lvList});
}

/**
 * 获取行业领域
 * @param req 
 * @param res 
 */
async function getIndustry(req, res) {
    let lvList = [];
    for (let key in INDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:INDUSTRY[key]});
        }
    }
    res.success({lvList});
}

/**
 * 获取孵化器投资方式
 * @param req 
 * @param res 
 */
 async function getFuHuaQiInvestmentStyle(req, res) {
    let lvList = [];
    for (let key in FUHUAQILNVESTMENTSTYLE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:FUHUAQILNVESTMENTSTYLE[key]});
        }
    }
    res.success({lvList});
}

