/**
 * 私有路由  用于维护迭代过程中造成的缺失数据
 * 注意：需要保证每个路由都使用  checkInterior  中间件
 */

import * as asyncHandler from 'express-async-handler';
import * as provideBiz from '../biz/admin/provide';
import { checkInterior } from '../middleware/user';


export function setRouter(httpServer) {
    httpServer.post('/admin/provide/task/add12',checkInterior, asyncHandler(provideLastTask));//已经弃用
    httpServer.post('/admin/provide/enterprise/updatestate',checkInterior, asyncHandler(updateEnterpriseState));
    httpServer.post('/admin/provide/task/updatetaskyear',checkInterior, asyncHandler(updateTaskYear));
    httpServer.post('/admin/provide/task/initScore',checkInterior, asyncHandler(initScore));
    httpServer.post('/admin/provide/task/replenishtaskcount',checkInterior, asyncHandler(replenishTaskCount));
    /**2.1 */
    httpServer.post('/admin/provide/data/updateadd',checkInterior, asyncHandler(updateAddress));
    /**3.0 */
    httpServer.post('/admin/provide/enterprise/enterpriseinfo',checkInterior, asyncHandler(enterpriseInfo));

    /**补录数据  已完成 */
    httpServer.post('/admin/provide/basedata/inputdata',checkInterior, asyncHandler(inputData));
    httpServer.post('/admin/provide/basedata/inputenterprise202304data',checkInterior, asyncHandler(inputEnterprise202304Data));

    /**3.2 */
    httpServer.post('/admin/provide/enterprise/initpwd', checkInterior, asyncHandler(updateEnterprisePwd) );
    
}

async function inputEnterprise202304Data(req, res) {
    await provideBiz.replaceInitEnberpriseData();
    res.success({isUsccess:true});
}

async function inputData(req, res) {
    await provideBiz.inputEnterpriseData();
    res.success({isUsccess:true});
}

/**
 * 手动发放一月份任务
 * 使用情况：1.0使用  已弃用
 * @param req 
 * @param res 
 */
async function provideLastTask(req, res) {
    await provideBiz.provideLastTask();
    res.success({isUsccess:true});
}


/**
 * 添加任务的年份字段  用于筛选数据 
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateTaskYear(req, res) {
    await provideBiz.updateFuHuaQiTaskYear();
    res.success({isUsccess:true});
}


/**
 * 更新企业的状态为 在孵企业
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateEnterpriseState(req, res) {
    await provideBiz.updateEnterpriseFuHuaState();
    res.success({isUsccess:true});
}


/**
 * 初始化所有孵化器分数
 * 使用情况：2.0使用
 * 备注：只能调用一次
 * @param req 
 * @param res 
 */
async function initScore(req, res) {
    await provideBiz.initScoreData();
    res.success({isUsccess:true});
}


async function replenishTaskCount(req, res) {
    await provideBiz.replenishTaskData();
    res.success({isUsccess:true});
}


async function updateAddress(req, res) {
    await provideBiz.updateAdd();
    res.success({isUsccess:true});
}

async function enterpriseInfo(req, res) {
    await provideBiz.updateEnterpriseDataInfo();
    res.success({isUsccess:true});
}

async function updateEnterprisePwd(req, res) {
    await provideBiz.initEnterprisePwd();
    res.success({isUsccess:true});
}