/**
 * 小程序端  孵化器入口  企业相关路由
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseBiz from '../../biz/mobileFuHuaQi/enterprise/enterprise';
import * as toExamineBiz from '../../biz/mobileFuHuaQi/enterprise/toExamine';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    /**新注册企业 或 新迁入企业 */
    httpServer.post('/fuhuaqi/enterprise/register', checkFuHuaQiToken, asyncHandler(registerEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updateregister', checkFuHuaQiToken, asyncHandler(updateRegisterEnterprise));
    httpServer.post('/fuhuaqi/enterprise/move', checkFuHuaQiToken, asyncHandler(moveInEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updatemove', checkFuHuaQiToken, asyncHandler(updateMoveInEnterprise));
    httpServer.post('/fuhuaqi/enterprise/select', checkFuHuaQiToken, asyncHandler(selectEnterpriseInfo));
    httpServer.post('/fuhuaqi/enterprise/delete', checkFuHuaQiToken, asyncHandler(delEnterpriseInfo));
    /**审核企业填报数据 */
    httpServer.post('/fuhuaqi/enterprise/examine/unaudited', checkFuHuaQiToken, asyncHandler(unaudited));
    httpServer.post('/fuhuaqi/enterprise/examine/auditcompleted', checkFuHuaQiToken, asyncHandler(auditCompleted));
    httpServer.post('/fuhuaqi/enterprise/examine/replenish', checkFuHuaQiToken, asyncHandler(replenish));
    httpServer.post('/fuhuaqi/enterprise/examine/pass', checkFuHuaQiToken, asyncHandler(passExamine));
    /**回显 */
    httpServer.post('/fuhuaqi/enterprise/examine/find/team', checkFuHuaQiToken, asyncHandler(teamEcho));
    httpServer.post('/fuhuaqi/enterprise/examine/find/business', checkFuHuaQiToken, asyncHandler(businessEcho));

}


/**
 * 添加新注册的企业信息
 * 1.0
 * @param req 
 * @param res 
 */
async function registerEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.registerEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 修改新注册的企业信息
 * 1.0
 * @param req 
 * @param res 
 */
async function updateRegisterEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateRegisterEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 添加迁入的企业信息 
 * 1.0
 * @param req 
 * @param res 
 */
 async function moveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.moveInEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 修改迁入企业登记信息 
 * 1.0
 * @param req 
 * @param res 
 */
async function updateMoveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateMoveInEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 查询迁入企业登记信息或新建企业登录信息 
 * 1.0
 * 回显
 * @param req 
 * @param res 
 */
 async function selectEnterpriseInfo(req, res) {
    /*这里改成了用DraftId,为了不改前端 依然使用uscc这个参数名称*/
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body); 

    let result = await enterpriseBiz.getEnterpriseByDraftId(uscc);
    res.success(result);
}


/**
 * 删除迁入企业登记信息或新建企业登录信息
 * 1.0
 * @param req 
 * @param res 
 */
async function delEnterpriseInfo(req, res) {
     /*这里改成了用DraftId,为了不改前端 依然使用uscc这个参数名称*/
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.deleteEnterpriseByDraftId(uscc);
    res.success(result);
}


/**
 * 待审核企业数据
 * 3.0
 * @param req 
 * @param res 
 */
async function unaudited(req, res) {
    const Uscc = req.headers.uscc;

    let result = await toExamineBiz.unauditedList(Uscc);
    res.success(result);
}


/**
 * 已审核企业数据
 * 3.0
 * @param req 
 * @param res 
 */
async function auditCompleted(req, res) {
    let reqConf = { year:"Number", quarter:"Number" };
    let { year, quarter } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await toExamineBiz.auditCompletedList(Uscc, year, quarter);
    res.success(result);
}


/**
 * 孵化器修改企业填报的数据
 * 3.0
 * @param req 
 * @param res 
 */
async function replenish(req, res) {
    let reqConf = { year:"Number", quarter:"Number", uscc:"String", type:"Number", form:"Object"};
    let { year, quarter, uscc, type, form} = eccReqParamater(reqConf, req.body);
    const fuHuaQiUscc = req.headers.uscc;
    let result = await toExamineBiz.fuHuaQiReplenishEnterpriseDataDeclaration(fuHuaQiUscc, uscc, type, year, quarter, form);
    res.success(result);
}

/**
 * 孵化器通过企业填报的数据
 * 3.0
 * @param req 
 * @param res 
 */
async function passExamine(req, res) {
    let reqConf = { year:"Number", quarter:"Number", uscc:"String", type:"Number"};
    let { year, quarter, uscc, type} = eccReqParamater(reqConf, req.body);
    const fuHuaQiUscc = req.headers.uscc;
    let result = await toExamineBiz.fuHuaQiPass(fuHuaQiUscc, uscc, type, year, quarter);
    res.success(result);
}


/**回显  */
async function teamEcho(req, res) {
    let reqConf = { year:"Number", quarter:"Number", uscc:"String"};
    let { year, quarter, uscc} = eccReqParamater(reqConf, req.body);
    const fuHuaQiUscc = req.headers.uscc;
    let result = await toExamineBiz.selectFuHuaQiReplenishEnterpriseTeamData(fuHuaQiUscc, uscc, year, quarter);
    res.success(result);
}


async function businessEcho(req, res) {
    let reqConf = { year:"Number", quarter:"Number", uscc:"String"};
    let { year, quarter, uscc} = eccReqParamater(reqConf, req.body);
    const fuHuaQiUscc = req.headers.uscc;
    let result = await toExamineBiz.selectFuHuaQiReplenishEnterpriseBusinessData(fuHuaQiUscc, uscc, year, quarter);
    res.success(result);
}
