/**
 * 短信提示 表
 * 记录每个月的提示情况
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const smsPointOutSchema = new Schema({
    month:Number,
    year:Number,
    type:Number,
    sendMs:Number
});


var smsPointOutModel;
export function initModel(){
    smsPointOutModel = baseDB.model('smspointout', smsPointOutSchema);
}

/**
 * 创建短信提示记录
 * @param month 提示月份
 * @param year 提示年份
 * @param type 提示类型
 * @returns 
 */
export async function createSmsPointOutData(month:number, year:number, type:number) {
    return await smsPointOutModel.create({
        month, year, type, sendMs:new Date().valueOf()
    });
}

/**
 * 根据年和月查询提示记录
 * @param month 月份
 * @param year 年份
 * @returns 
 */
export async function findSmsPointOutData(month:number, year:number) {
    return await smsPointOutModel.findOne({month, year});
}
