
import moment = require("moment");
import * as fuhuaqiData from "../../../data/fuHuaQi/fuhuaqi";
import * as monthData from "../../../data/fuHuaQi/monthTask/monthTable";
import * as enterpriseData from "../../../data/enterprise/enterprise";

export async function getTestABI() {
    let res =  await fuhuaqiData.findFuHuaQiList({});
    return {dataList:res}
}

/**
 * 孵化器平均月度出租率   
 * @returns occupancyRateAvg 该月的月度出租率
 */
export async function getAvgOccupancyRate() { 
    let year = moment().format("YYYY");
    let month = moment().subtract(1, 'M').format("M");
    let dataBaseList = await monthData.findMonthTableList({year,month, isUpdate:true, draftLock:true});
    let occupancyRate = 0;
    dataBaseList.forEach( info => {
        if (info.occupancyRate) {
            occupancyRate = occupancyRate + info.occupancyRate;
        }
    });

    let occupancyRateAvg = dataBaseList.length ? Math.round(((occupancyRate)/dataBaseList.length)) : 0;

    return {"孵化器平均出租率": occupancyRateAvg};
}


/**
 * 孵化器总面积
 * @returns acreageTotal 所有孵化器的总面积
 */
export async function getAcreageTotal() {
    let dataBaseList = await fuhuaqiData.findFuHuaQiList({});
    let acreageTotal = 0;
    dataBaseList.forEach( info => {
        if (info.acreageTotal) acreageTotal = acreageTotal + Math.floor(info.acreageTotal);
    });

    return {"孵化总面积": acreageTotal};
}


/**
 * 机构性质
 * @returns dataList
 */
export async function getInstitutionalNature() {
    let 国资为主 = await fuhuaqiData.findFuHuaQiCount({institutionalNature:1});
    let 民资为主 = await fuhuaqiData.findFuHuaQiCount({institutionalNature:2});
    let 外资为主 = await fuhuaqiData.findFuHuaQiCount({institutionalNature:3});

    let dataList = [
        {
            key:"国资为主",
            value:国资为主
        },
        {
            key:"民资为主",
            value:民资为主
        },
        {
            key:"外资为主",
            value:外资为主
        }
    ]

    return dataList;
}


/**
 * 资质情况
 * @returns 
 */
export async function getlv() {
    let 国家级众创空间 = await fuhuaqiData.findFuHuaQiCount({lv:1});
    let 市级众创空间 = await fuhuaqiData.findFuHuaQiCount({lv:2});
    let 国家级孵化器 = await fuhuaqiData.findFuHuaQiCount({lv:3});
    let 市级孵化器 = await fuhuaqiData.findFuHuaQiCount({lv:4});
    let 区级 = await fuhuaqiData.findFuHuaQiCount({lv:5});

    let dataList = [
        {
            key:"国家级众创空间",
            value:国家级众创空间
        },
        {
            key:"市级众创空间",
            value:市级众创空间
        },
        {
            key:"国家级孵化器",
            value:国家级孵化器
        },
        {
            key:"市级孵化器",
            value:市级孵化器
        },
        {
            key:"区级",
            value:区级
        }
    ]

    return dataList;
}


/**
 * 在孵企业数（家）
 * @returns enterpriseTotal 在孵企业数（家）
 */
 export async function getEnterpriseTotal() {
    let enterpriseTotal = await enterpriseData.findEnterpriseCount({});
    return {"在孵企业数":enterpriseTotal};
}