/**
 * 张江以外布局 逻辑
 * 作者：lxm
 * 
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as zjBeyondLayoutData  from "../../../../data/fuHuaQi/instituQualify/zjBeyondLayout";
import { changeEnumValue } from "../../../../util/verificationEnum";
import { ZJBEYONDLAYOUTOPERATIONMODE } from "../../../../config/enum";


/**
 * 创建 张江以外布局信息
 * @param uscc 孵化器统一信用代码
 * @param city 布局城市
 * @param area 空间面积
 * @param operationMode 运营模式
 * @returns 
 */
export async function createZJBeyondLayout(uscc:string, city:string, area:number, operationMode:number) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await zjBeyondLayoutData.addData(id, uscc, fuHuaQiInfo.name, city, area, operationMode);
    return {isSuccess:true};
}


/**
 * 修改 张江以外布局信息
 * @param uscc 孵化器统一信用代码
 * @param id 信息标识
 * @param city 布局城市
 * @param area 空间面积
 * @param operationMode 运营模式
 * @returns 
 */
export async function updateZJBeyondLayout(uscc:string, id:string, city:string, area:number, operationMode:number) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    dataInfo.city = city; 
    dataInfo.area = area; 
    dataInfo.operationMode = operationMode; 

    await dataInfo.save();

    return {isSuccess:true};
}


/**
 * 回显 张江以外布局信息
 * @param id 信息标识
 * @returns 
 */
export async function selectZJBeyondLayout(id:string) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    let layoutData = {
        city:dataInfo.city,
        area:dataInfo.area,
        operationMode:dataInfo.operationMode
    };

    return {layoutData} 
}


/**
 * 删除 张江以外布局信息
 * @param id 信息标识
 * @returns 
 */
export async function deleteZJBeyondLayout(id:string) {
    await zjBeyondLayoutData.deleteDataById(id);

    return {isSuccess:true} 
}


/**
 * 获取 张江以外布局信息 列表
 * @param uscc 孵化器统一信用代码
 * @returns 
 */
export async function getZJBeyondLayoutListData(uscc:string) {
    let registerList = await zjBeyondLayoutData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            city:info.city,
            area:info.area,
            operationMode:changeEnumValue(ZJBEYONDLAYOUTOPERATIONMODE, info.operationMode)
        });
    });

    return {dataList, title:"张江以外布局情况"}
}
