/**
 * 孵化器 创业导师 逻辑
 * 作者：lxm
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as startupTeacherData  from "../../../../data/fuHuaQi/instituQualify/startupTeacher";
import { changeEnumValue } from "../../../../util/verificationEnum";
import { SPECIALITY, TEACHERLV } from "../../../../config/enum";


/**
 * 创建 创业生导师 信息
 * @param uscc 孵化器统一信用代码
 * @param teacherName 导师名称
 * @param unit 单位
 * @param duties 职务
 * @param speciality 专业特长
 * @param teacherLv 导师级别
 * @param serviceEnterprises 服务企业名单
 * @returns 
 */
export async function createStartUpTeacher(uscc:string, teacherName:string, unit:string, duties:string, speciality, teacherLv:number, serviceEnterprises:string) {

    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await startupTeacherData.addData(id, uscc, fuHuaQiInfo.name, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises);
    
    return {isSuccess:true};
}


/**
 * 修改 创业生导师 信息
 * @param uscc 孵化器统一信用代码
 * @param id 标识
 * @param teacherName 导师名称 
 * @param unit 单位 
 * @param duties 职务 
 * @param speciality 专业特长 
 * @param teacherLv 导师级别 
 * @param serviceEnterprises 服务企业名单 
 * @returns 
 */
export async function updateStartUpTeacher(uscc:string, id:string, teacherName:string, unit:string, duties:string, speciality, teacherLv:number, serviceEnterprises:string) {
    let dataInfo = await startupTeacherData.findOneData(id);

    dataInfo.teacherName = teacherName; 
    dataInfo.unit = unit; 
    dataInfo.duties = duties; 
    dataInfo.speciality = speciality; 
    dataInfo.teacherLv = teacherLv; 
    dataInfo.serviceEnterprises = serviceEnterprises;

    await dataInfo.save();

    return {isSuccess:true};
}


/**
 * 回显创业导师信息 
 * @param id 信息标识
 * @returns 
 */
export async function selectStartUpTeacher(id:string) {
    let dataInfo = await startupTeacherData.findOneData(id);

    let startUpData = {
        teacherName:dataInfo.teacherName,
        unit:dataInfo.unit,
        duties:dataInfo.duties,
        speciality:dataInfo.speciality,
        teacherLv:dataInfo.teacherLv,
        serviceEnterprises:dataInfo.serviceEnterprises,
    };

    return {startUpData} 
}


/**
 * 删除 创业生导师信息
 * @param id 信息标识
 * @returns 
 */
export async function deleteStartUpTeacher(id:string) {
    await startupTeacherData.deleteDataById(id);

    return {isSuccess:true} 
}


/**
 * 获取 创业生导师列表
 * @param uscc 信息标识
 * @returns 
 */
export async function getStartUpTeacherListData(uscc) {
    let registerList = await startupTeacherData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            teacherName:info.teacherName,
            unit:info.unit,
            duties:info.duties,
            speciality:changeEnumValue(SPECIALITY, info.speciality),
            teacherLv:changeEnumValue(TEACHERLV, info.teacherLv),
            serviceEnterprises:info.serviceEnterprises,
        });
    });

    return {dataList, title:"创业导师情况"}
}
