/**
 * 小程序端 企业用户的 企业基础信息
 * 作者：lxm
 */

import { EnterpriseUpdateBaseDataConfig } from "../../../config/eccParam/enterprise";
import { INDUSTRY, STATEENUM } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { EnterpriseBaseConfig } from "../../../config/splitResultConfig";
import * as enterpriseData from "../../../data/enterprise/enterprise";
import { findEnterpriseNewTeamData } from "../../../data/enterprise/quarterTask/team";
import { BizError } from "../../../util/bizError";
import { checkChange, checkDataHaveNull, extractData } from "../../../util/piecemeal";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";


/**
 * 获取首页基础信（首页顶端数据）
 * 知识产权，融资情况，企业资质 第一次进来会红，点开之后红点提示 会永久消失  2023-05-08
 * @param uscc 企业统一信用代码
 * @returns 
 */
export async function getHomePageHeaderData(uscc:string) {
    let enterpriseInfo = await enterpriseData.selectOneEnterpriseByParam({uscc});

    //企业名称
    let name = enterpriseInfo.name;

    let newTeamInfo = await findEnterpriseNewTeamData(uscc);
    let teamInfo = Object.keys(newTeamInfo).length > 0 ?  newTeamInfo : {doctor:0, master:0, undergraduate:0, juniorCollege:0, other:0 };

    //团队总数
    let memberCount = teamInfo.doctor + teamInfo.master+ teamInfo.undergraduate+ teamInfo.juniorCollege+ teamInfo.other;

    let initialTeam = enterpriseInfo.haveFirstClassTalent == STATEENUM.未选 ||  !enterpriseInfo.haveFirstClassTalent;//创始团队缺失 true=缺失 

    
    let qualification = !enterpriseInfo.tipsQualification; //企业资质缺失 true=缺失 需要标红
    let intellectualProperty = !enterpriseInfo.tipsIntellectualProperty;//知识产权缺失 true=缺失 需要标红
    let financing = !enterpriseInfo.tipsFinancingInfo; //融资情况缺失 true=缺失 需要标红

    let checkEnterpriseInfo = extractData(EnterpriseBaseConfig, enterpriseInfo, false);
    let baseInfo = checkDataHaveNull(checkEnterpriseInfo, true)

    return {
        name,
        memberCount,
        hiatus:{
            initialTeam,
            qualification,
            financing,
            intellectualProperty,
            baseInfo
        }
    }
}



/**
 * 获取企业基本信息
 * 回显
 * @param uscc 
 */
export async function enterpriseBaseInfo(uscc:string) {
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    let updateInfo = extractData(EnterpriseBaseConfig, enterpriseInfo, false);

    return updateInfo;
}


/**
 * 修改我的企业信息
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function updateEnterpriseBaseInfo(uscc:string, param) { 
    eccFormParam("企业修改我的信息", EnterpriseUpdateBaseDataConfig, param );
    eccEnumValue('企业修改我的信息', 'industry', INDUSTRY, param.industry);

    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    /**修改字段 */
    let changeList = checkChange(param, enterpriseInfo);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);
    changeList.forEach(key => {
        if (key != "uscc" && key != "name") {
            enterpriseInfo[key] = param[key];
        }
    });

    await enterpriseInfo.save();
    
    return {isSuccess:true};
}

