import { OUTPUTTYPE } from "../../../config/enum";
import { findAllFuHuaQiOperationNameMap } from "../../../data/fuHuaQi/fuhuaqi";
import { distinctFuHuaQiRegister, findI18nRegisterListByParam, findI18nRegisterListByParamToPage, getI18nRegisterCountByParam } from "../../../data/fuHuaQi/instituQualify/i18nRegister";



/**
 * 国际化已登记列表
 * @param name 孵化器运营机构名称  模糊查询
 * @param page 页面 
 * @returns 
 */
export async function getI18nRegisterDataList(name:string, page:number) {
    let selectParam:any = {};
    if (name) selectParam.name = {"$regex":`${name}`};

    let dataBaseList = await findI18nRegisterListByParamToPage(selectParam, (page-1)*10);
    let count = await getI18nRegisterCountByParam(selectParam);
    let dataList = [];
    dataBaseList.forEach(info => {
        dataList.push({
            name:info.name,
            country:info.country || '',//国家
            partners:info.partners || '',//合作机构
            cMode:info.cMode || '',//合作方式
            cAchievements:info.cAchievements || '',//合作成果
        });
    });

    return {count, dataList, pageCount:Math.ceil(count/10) };
}


export async function outPutI18nRegisterDataList(name:string) {}


/**
 * 国际化未登记列表
 * @param name 孵化器运营机构名称 模糊
 * @param page 页面
 * @returns 
 */
export async function getI18nNotRegisterDataList(name:string, page:number) {
    let selectParam:any = {};
    if (name) selectParam.name = {"$regex":`${name}`};

    //填报孵化器列表
    let registerMap = await distinctFuHuaQiRegister();

    //全部孵化器map
    let fuHuaQiMap = await findAllFuHuaQiOperationNameMap();

    let notRegisterList = [];
    for (let uscc in fuHuaQiMap) {
        if (!registerMap[uscc]) notRegisterList.push({
            uscc, 
            name:fuHuaQiMap[uscc], 
            country: '-', 
            partners:'-', 
            cMode:'-',
            cAchievements: '-'
        });
    }

    let dataList = notRegisterList.slice((page-1)*10, ((page-1)*10)+10);
    let count = notRegisterList.length;
    
    return {count, dataList, pageCount:Math.ceil(count/10) };
}


/**
 * 导出 国际化登记列表  （已填报）
 * @param name 孵化器运营机构名称  
 * @param type 导出类型
 */
export async function outPutI18nNotRegisterData(fuHuaQiName:string, type:number) {

    let name = "全部";
    let selectParam:any = {};

    if (type == OUTPUTTYPE.当前数据 ) {
        name = "当前";
        if (fuHuaQiName) selectParam.name = {"$regex":`${fuHuaQiName}`};
    }

    let dataBaseList = await findI18nRegisterListByParam(selectParam);

    let dataList = [["运营机构名称", "国家", "合作机构","合作方式","合作成果"]];
    dataBaseList.forEach(info => {
        let subList = [info.name, info.country, info.partners, info.cMode, info.cAchievements ];
        dataList.push(subList);
    });

    return {dataList, name};

}
