/**
 * 孵化器 任务相关工具
 * 只允许被孵化器任务相关逻辑使用
 * 
 */
import moment = require("moment");
const md5 = require("md5");



/**----------------------------------------------月度任务   */
/**
 * 获取日期的key
 * @param timeMs 指定时间, 如果不传就是当前数据
 * @returns YYYYM
 */
export function getTimeKey(timeMs?) {
    if (timeMs) return parseInt(`${new Date(timeMs).getFullYear()}${new Date(timeMs).getMonth() + 1 }`);
    return parseInt(`${new Date().getFullYear()}${new Date().getMonth() + 1 }`);
}


/**
 * 生成月度任务id
 * @param uscc 企业统一信用代码
 *  @returns uscc+YYYYM
 */
export function generateMonthTaskId(uscc:string) {
    return `${uscc}${getTimeKey()}`;
}


/**
 * 获取当前时间月度任务id
 * @param uscc 企业标识
 * @returns uscc+YYYYM
 */
export function getTaskId(uscc:string) {
    return `${uscc}${getTimeKey()}`;
}


/**
 * 根据时间获取任务id
 * @param uscc 企业标识
 * @param timeMs 时间戳
 * @returns uscc+YYYYM
 */
export function getMonthTaskIdByTime(uscc:string, timeMs:number) {
    return `${uscc}${getTimeKey(timeMs) }`;
}


/**
 * 获取上一个月的日期标识
 * @returns YYYYM(当前月的上一个月)
 */
export function getLastMonthTimeKey() {
    return moment().subtract(1,'months').format('YYYYM');
}

/** -----------------------------------------------  季度任务 */ 


/**
 * 生成季度任务id
 * 生成时所在季度
 * @param uscc 企业标识
 * @returns uscc+YYYY+0+Quarter
 */
export function generateQuarterTaskId(uscc:string) {
    let thisQuarter = moment().quarter();//当月填报季度
    return `${uscc}${new Date().getFullYear()}0${thisQuarter}`;
}


/**
 * 获取当前季度任务id
 * 季度是以填报季度,也就是当前季度当前季度
 * @param uscc 企业标识
 * @returns uscc+YYYY+0+Quarter
 */
export function getQuarterTaskId(uscc:string) {
    let thisQuarter = moment().quarter();//当月填报季度
    return `${uscc}${new Date().getFullYear()}0${thisQuarter}`;
}


/**
 * 获取当前季度的时间标识
 * @returns YYYY+0+Quarter
 */
export function getQuarterTimeKey() {
    return parseInt(`${new Date().getFullYear()}0${moment().quarter()}`);
}


/**
 * 获取指定时间戳的任务id
 * @param uscc 孵化器统一信用代码
 * @param timeMs 时间标识
 * @returns uscc+YYYY+0+Quarter
 */
export function getQuarterTaskIdByTime(uscc:string, timeMs:number) {
    return `${uscc}${new Date(timeMs).getFullYear()}0${moment(timeMs).quarter() }`;
}


/**
 * 根据指定年和季度生成任务id
 * @param uscc 孵化器统一信用代码
 * @param year 年
 * @param quarter 季度 
 * @returns uscc+YYYY+0+Quarter
 */
export function getQuarterTaskIdByYearAndQuarter(uscc:string, year:number, quarter:number) {
    return `${uscc}${year}0${quarter }`;
}