/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
const md5 = require("md5");


/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


/**
 * 获取绑定id
 * @param uscc 孵化器统一信用代码
 * @param bindUscc 被绑定的孵化器统一信用代码
 * @returns 
 */
export function getBindId(uscc:string, bindUscc:string) {
    return md5(`${uscc}${bindUscc}${Math.ceil(Math.random() *100)}`);
} 


/**
 * 获取今天开始时刻的时间戳  0时0分
 * @returns 
 */
export function getTodayMs() {
    let t =`${ moment().format("YYYY-MM-DD")} 00:00:00`;
    return new Date(t).valueOf();
}

/**
 * 获取这个月的开始时刻的时间戳  0时0分
 * @returns 
 */
export function getThisMonthMs() {
    let t =`${ moment().format("YYYY-MM")}-01 00:00:00`;
    return new Date(t).valueOf();
}


/**
 * 获取code的id
 * @param uscc 发送人的uscc
 * @param todaySendCount 今日发送次数
 * @returns ''
 */
export function getSMSCodeId(uscc:string, todaySendCount:number) {
    return md5(`${uscc}${todaySendCount}${new Date().valueOf()}`);
}


/**
 * 获取一个随机6位数的验证码
 * @returns 
 */
export function getSMSCode() {
    let code = ``;
    for (let i =0; i < 6; i++) {
        code += Math.floor(Math.random() * 10)
    }
    return code;
}


/**
 * 生成融资id
 * @param uscc 
 * @returns 
 */
export function getFinancingId(uscc) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() * 1000)}`);
}


/**
 * 生成创始团队成员id
 * @param uscc 
 * @param name 
 * @returns 
 */
export function getInitialTeamMemberId(uscc:string, name:string) {
    return md5(`${uscc}${name}${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


/**
 * 生成 资讯id
 * @returns 
 */
export function getInformationId() {
    return md5(`${Math.ceil(Math.ceil(Math.random() * 1000000))}${new Date().valueOf() }${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


/**
 * 获取上一个季度 年和季度
 * @returns declarationYear：数据填报年   declarationQuarter：数据填报季度
 */
export function getLastQuarter() {
    let thisYear = new Date().getFullYear();
    let thisQuarter = moment().quarter();//当月填报季度
    if ( (thisQuarter - 1) < 1 ) {
        thisYear = moment().subtract(1, 'years').year();
        thisQuarter = 4;
    } else thisQuarter = thisQuarter - 1;
    return {year:thisYear, quarter:thisQuarter};
}


export function getI18nRegisterId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf() }${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}


export function getPolicyBGImgId() {
    return `bgImg_${md5(`bgImg${new Date().valueOf()}${Math.ceil(Math.ceil(Math.random() * 1000000))}`)}`
}

/**
 * 获取随机id
 * @param uscc 
 */
export function getRandomId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf() }${Math.ceil(Math.ceil(Math.random() * 1000000))}`);
}

export function changeAddToString(address) {
    let str = "";
    address.forEach(item => {
        str += item;
    });
    return str;
}
