/**
 * 小程序端  孵化器入口  企业相关路由
 */

import * as asyncHandler from 'express-async-handler';
import * as myEnterpriseBiz from '../../biz/mobileFuHuaQi/enterprise/myEnterprise';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { FUHUASTATE } from '../../config/enum';

export function setRouter(httpServer) {
    /**我的企业 */
    httpServer.post('/fuhuaqi/myenterprise/list', checkFuHuaQiToken, asyncHandler(myEnterpriseList));
    httpServer.post('/fuhuaqi/myenterprise/moveoutlist', checkFuHuaQiToken, asyncHandler(myEnterpriseMoveOutList));
    httpServer.post('/fuhuaqi/myenterprise/info', checkFuHuaQiToken, asyncHandler(myEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/update', checkFuHuaQiToken, asyncHandler(updateMyEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/replenish/create', checkFuHuaQiToken, asyncHandler(replenishCreate));
    httpServer.post('/fuhuaqi/myenterprise/replenish/input', checkFuHuaQiToken, asyncHandler(replenishInPut));
    /**我的企业 修改 */
    httpServer.post('/fuhuaqi/myenterprise/update/physical', checkFuHuaQiToken, asyncHandler(updatePhysical));
    httpServer.post('/fuhuaqi/myenterprise/update/virtual', checkFuHuaQiToken, asyncHandler(updateVirtual));
    httpServer.post('/fuhuaqi/myenterprise/update/moveout', checkFuHuaQiToken, asyncHandler(updateMoveOut));
    /**4.2 */
    httpServer.post('/fuhuaqi/myenterprise/qualification/select', checkFuHuaQiToken, asyncHandler(myEnterpriseQualification));
    httpServer.post('/fuhuaqi/myenterprise/teaminfo/select', checkFuHuaQiToken, asyncHandler(myEnterpriseTeamInfo));
    httpServer.post('/fuhuaqi/myenterprise/businessdata/select', checkFuHuaQiToken, asyncHandler(myEnterpriseBusinessData));
     

}


/**
 * 我的企业列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseList(req, res) {
    let reqConf = {name: 'String', state:"Number", page:"Number" };
    let { name, state, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await myEnterpriseBiz.myEnterprise(Uscc, state, name, page);

    res.success(data);
}


/**
 * 我的企业列表迁出列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseMoveOutList(req, res) {
    let reqConf = {name: 'String', page:"Number" };
    let { name, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await myEnterpriseBiz.myEnterprise(Uscc, FUHUASTATE.迁出, name, page);

    res.success(data);
}


/**
 * 企业基本信息
 * 我的企业列表中的企业基本信息
 * 回显
 * 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseInfo(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;
    let result = await myEnterpriseBiz.getMyEnterpriseBaseInfo(FuHuaQiUscc, uscc);
    res.success(result);
}


/**
 * 修改企业孵化状态 修改为实体
 * 2.0
 * @param req 
 * @param res 
 */
async function updatePhysical(req, res) {
    let reqConf = {leasedArea: 'Number', uscc:"String" };
    let { leasedArea, uscc } = await eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updatePhysicalInfo(FuHuaQiUscc, uscc, leasedArea);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为虚拟
 * 2.0
 * @param req 
 * @param res 
 */
async function updateVirtual(req, res) {
    let reqConf = {virtualCause: 'Number', uscc:"String" , virtualCauseDes:"String"};
    let { virtualCause, uscc, virtualCauseDes} = await eccReqParamater(reqConf, req.body, ["virtualCauseDes"]);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateVirtualInfo(FuHuaQiUscc, uscc, virtualCauseDes, virtualCause);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为迁出
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMoveOut(req, res) {
    let reqConf = {moveOutType: 'Number', uscc:"String" , moveOutTrace:"Number", moveOutCause:"[Number]"};
    const skipList = ["moveOutTrace", "moveOutCause"];
    let { moveOutType, uscc, moveOutCause, moveOutTrace } = await eccReqParamater(reqConf, req.body, skipList);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateMoveOutInfo(FuHuaQiUscc, uscc, moveOutType, moveOutTrace, moveOutCause);

    res.success(result);
}


/**
 * 修改我的企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMyEnterpriseInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateMyEnterpriseBaseInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新注册企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishCreate(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.replenishMyEnterpriseCreateInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新迁入企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishInPut(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.replenishMyEnterpriseInPutInfo(Uscc, form);
    res.success(result);
}


/**
 * 企业资质
 * 4.2
 * @param req 
 * @param res 
 */
async function myEnterpriseQualification(req, res) {
    let reqConf = {uscc:"String"};
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseQualification(uscc);
    res.success(result);
}


/**
 * 企业团队
 * 4.2
 * @param req 
 * @param res 
 */
async function myEnterpriseTeamInfo(req, res) {
    let reqConf = {uscc:"String"};
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseTeamInfo(uscc);
    res.success(result);
}


/**
 * 经济状况
 * @param req 
 * @param res 
 */
async function myEnterpriseBusinessData(req, res) {
    let reqConf = {uscc:"String", year:"Number"};
    let { uscc, year } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseBusinessData(uscc, year);
    res.success(result);
}

