/**
 * 小程序端  孵化器入口  月度报表功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as monthBiz from '../../biz/mobileFuHuaQi/fuHuaQi/month';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/month/addreport', checkFuHuaQiToken, asyncHandler(addReport));
    httpServer.post('/fuhuaqi/month/updatereport', checkFuHuaQiToken, asyncHandler(updateReport));
    httpServer.post('/fuhuaqi/month/deletereport', checkFuHuaQiToken, asyncHandler(deleteReport));
    httpServer.post('/fuhuaqi/month/select', checkFuHuaQiToken, asyncHandler(selectMonthInfo));
}


/**
 * 孵化器月度填报 新增报表
 * @param req 
 * @param res 
 */
async function addReport(req, res) {
    let reqConf = {occupancyRate: 'Number' };//这里可以填0
    let { occupancyRate } = eccReqParamater(reqConf, req.body, ["occupancyRate"]);
    const Uscc = req.headers.uscc;

    let monthInfo = await monthBiz.createReport(Uscc, occupancyRate);
    res.success(monthInfo);
}


/**
 * 孵化器月度填报  删除报表
 * @param req 
 * @param res 
 */
async function deleteReport(req, res) {
    const Uscc = req.headers.uscc;

    let monthInfo = await monthBiz.deleteReport(Uscc);
    res.success(monthInfo);
}


/**
 * 查询月度报表信息 
 * @param req 
 * @param res 
 */
 async function selectMonthInfo(req, res) {
    const Uscc = req.headers.uscc;

    let result = await monthBiz.getMonthByUscc(Uscc);
    res.success(result);
}


/**
 * 孵化器月度填报 修改报表
 * @param req 
 * @param res 
 */
async function updateReport(req, res) {
    let reqConf = {occupancyRate: 'Number' };
    let { occupancyRate } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let monthInfo = await monthBiz.updateReport(Uscc, occupancyRate);
    res.success(monthInfo);
}