/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../../biz/mobileEnterprise/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkEnterpriseToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/enterprise/login', asyncHandler(login));
    httpServer.post('/enterprise/user/firstchangepwd', checkEnterpriseToken,  asyncHandler(firstLoginChangeEnterprisePwd));
    httpServer.post('/enterprise/changepwd/resetting',  asyncHandler(resettingEnterprisePwd));
    httpServer.post('/enterprise/changepwd/sendcode',  asyncHandler(changeEnterprisePwdSendCode));
    httpServer.post('/enterprise/user/firstupdatepwdstate', checkEnterpriseToken, asyncHandler(firstUpdatePwdState));
}


/**
 * 企业登录 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {uscc:'String', pwd:'String'};
    let {uscc, pwd} = eccReqParamater(reqConf, req.body);
    
    let result = await userBiz.enterpriseLogin(uscc, pwd);

    res.success(result);
}


/**
 * 首次登录修改密码
 * @param req 
 * @param res 
 */
async function firstLoginChangeEnterprisePwd(req, res) {
    let reqConf = {confirmPwd:'String', pwd:'String'};
    let {confirmPwd, pwd} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    
    let result = await userBiz.firstChangePwd(Uscc, pwd, confirmPwd);

    res.success(result);
}


/**
 * 重置密码
 * @param req 
 * @param res 
 */
async function resettingEnterprisePwd(req, res) {
    let reqConf = { phone:"String", uscc:"String", code:"String", pwd:"String", confirmPwd:"String"};
    let {phone, uscc, code, pwd, confirmPwd} = eccReqParamater(reqConf, req.body);
   
    let result = await userBiz.resettingPwd(phone, uscc, code, pwd, confirmPwd);

    res.success(result);
}



/**
 * 重置密码发验证码
 * @param req 
 * @param res 
 */
async function changeEnterprisePwdSendCode(req, res) {
    let reqConf = {uscc:'String', phone:'String'};
    let {uscc, phone} = eccReqParamater(reqConf, req.body);
    
    let result = await userBiz.changePwdSendCode(uscc, phone);

    res.success(result);
}


/**
 * 获取孵化器首次登录状态
 * @param uscc 
 * @returns 
 */
export async function firstUpdatePwdState(req, res) {
    const Uscc = req.headers.uscc;
    
    let result = await userBiz.getFirstUpdatePwdState(Uscc);

    res.success(result);

   
}