/**
 *  统计 （管理后台 数字看板） 路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as statsFuHuaQiBiz from '../../biz/admin/stats/fuHuaQi/baseData';
import * as statsFuHuaQiOperateBiz from '../../biz/admin/stats/fuHuaQi/operate';
import * as statsFuHuaQiValueAnalysisBiz from '../../biz/admin/stats/fuHuaQi/valueAnalysis';
import * as statsWarningBiz from '../../biz/admin/stats/fuHuaQi/warning';

import * as fuhuaqiBaseBiz from '../../biz/admin/stats/guanWeiHui/fuhuaqiBase';
import * as enterpriseBaseBiz from '../../biz/admin/stats/guanWeiHui/enterpriseBase';
import * as guanWeiHuiFuHuaQiWarningBiz from '../../biz/admin/stats/guanWeiHui/fuHuaQiWarning';
import * as guanWeiHuiEnterpriseWarningBiz from '../../biz/admin/stats/guanWeiHui/enterpriseWarning';


export function setRouter(httpServer) {
    httpServer.post('/admin/stats/fuhuaqi/base/select',checkGuanWeiHuiToken, asyncHandler(fuhuaqiBase));
    httpServer.post('/admin/stats/fuhuaqi/base/update',checkGuanWeiHuiToken, asyncHandler(updateFuhuaqiBase));
    httpServer.post('/admin/stats/fuhuaqi/operate',checkGuanWeiHuiToken, asyncHandler(operateStats));
    httpServer.post('/admin/stats/fuhuaqi/value',checkGuanWeiHuiToken, asyncHandler(valueStats));
    httpServer.post('/admin/stats/fuhuaqi/warning/overview',checkGuanWeiHuiToken, asyncHandler(fuHuaQiWarningOverView));
    httpServer.post('/admin/stats/fuhuaqi/warning/task',checkGuanWeiHuiToken, asyncHandler(fuHuaQiTaskNotFilling));
    httpServer.post('/admin/stats/fuhuaqi/warning/addconflict',checkGuanWeiHuiToken, asyncHandler(fuHuQiAddConflict));
    httpServer.post('/admin/stats/fuhuaqi/warning/lettingrate',checkGuanWeiHuiToken, asyncHandler(fuHuaQiLettingRate));
    /**管委会看板 */
    httpServer.post('/admin/stats/guanweih/fuhuaqibase',checkGuanWeiHuiToken, asyncHandler(fuHuaQiBaseStats));
    httpServer.post('/admin/stats/guanweih/enterprisebase',checkGuanWeiHuiToken, asyncHandler(enterpriseBaseStats));
    httpServer.post('/admin/stats/guanweih/fuhuaqi/warning/overview',checkGuanWeiHuiToken, asyncHandler(guanWeiHuiFHQWarningOverView));
    httpServer.post('/admin/stats/guanweih/fuhuaqi/warning/revenueanomaly',checkGuanWeiHuiToken, asyncHandler(getRevenueAnomaly));
    httpServer.post('/admin/stats/guanweih/fuhuaqi/warning/fuhuaqitpanomaly',checkGuanWeiHuiToken, asyncHandler(getFuHuaQiTPAnomaly));
    httpServer.post('/admin/stats/guanweih/fuhuaqi/warning/teamanomaly',checkGuanWeiHuiToken, asyncHandler(getTeamAnomaly));

    httpServer.post('/admin/stats/guanweih/enterprise/warning/overview',checkGuanWeiHuiToken, asyncHandler(guanWeiHuiEnterpriseWarningOverView));
    httpServer.post('/admin/stats/guanweih/enterprise/warning/revenueanomaly',checkGuanWeiHuiToken, asyncHandler(getEnterpriseBussinessAnomaly));
    httpServer.post('/admin/stats/guanweih/enterprise/warning/txpanomaly',checkGuanWeiHuiToken, asyncHandler(getEnterpriseTXPAnomaly));
    httpServer.post('/admin/stats/guanweih/enterprise/warning/teamanomaly',checkGuanWeiHuiToken, asyncHandler(getEnterpriseTeamAnomaly));
}


/**
 * 管理后台-数字看板-孵化器看板-基础信息
 * @param req 
 * @param res 
 */
async function fuhuaqiBase(req, res) {
    let reqConf = {
        uscc: 'String',
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsFuHuaQiBiz.fuHuaQiBaseData(uscc);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-修改基础信息
 * @param req 
 * @param res 
 */
async function updateFuhuaqiBase(req, res) {
    let reqConf = {
        uscc: 'String', //
        form:'Object'//表单
    };
    const NotMustHaveKeys = [];
    let { uscc, form } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await statsFuHuaQiBiz.updateFuHuaQiBaseData(uscc, form);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-运营分析
 * @param req 
 * @param res 
 */
async function operateStats(req, res) {
    let reqConf = {
        uscc: 'String',
        year: 'Number'//年度 必填
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc, year } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsFuHuaQiOperateBiz.fuHuaQiOperateStats(uscc, year);
    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-价值分析
 * @param req 
 * @param res 
 */
async function valueStats(req, res) {
    let reqConf = {
        uscc: 'String'
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsFuHuaQiValueAnalysisBiz.getValueStats(uscc);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-风险管理 概览
 * @param req 
 * @param res 
 */
async function fuHuaQiWarningOverView(req, res) {
    let reqConf = {
        uscc: 'String'
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsWarningBiz.worningTips(uscc);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-风险管理-孵化器本年未填报 概览
 * @param req 
 * @param res 
 */
async function fuHuaQiTaskNotFilling(req, res) {
    let reqConf = {
        uscc: 'String',
        page: 'Number'
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsWarningBiz.fuHuaQiTaskNotFillingList(uscc, page);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-风险管理-地址冲突 概览
 * @param req 
 * @param res 
 */
async function fuHuQiAddConflict(req, res) {
    let reqConf = {
        uscc: 'String',
        page: 'Number'
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsWarningBiz.fuHuQiAddConflictList(uscc, page);

    res.success(result);
}


/**
 * 管理后台-数字看板-孵化器看板-出租率异常 概览
 * @param req 
 * @param res 
 */
async function fuHuaQiLettingRate(req, res) {
    let reqConf = {
        uscc: 'String',
        page: 'Number'
    };
    const NotMustHaveKeys = ["uscc"];
    let { uscc, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    uscc = uscc || "913101157664917120";
    let result = await statsWarningBiz.fuHuaQiLettingRateList(uscc, page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-孵化器信息
 * @param req 
 * @param res 
 */
async function fuHuaQiBaseStats(req, res) {

    let result = await fuhuaqiBaseBiz.fuHuaQiBaseData();

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-企业信息
 * @param req 
 * @param res 
 */
async function enterpriseBaseStats(req, res) {

    let result = await enterpriseBaseBiz.enterpriseBaseData();

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-孵化器风险预警-概览
 * @param req 
 * @param res 
 */
async function guanWeiHuiFHQWarningOverView(req, res) {

    let result = await guanWeiHuiFuHuaQiWarningBiz.fuHuaQiWarningOverView();

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-营收异常 
 * @param req 
 * @param res 
 */
async function getRevenueAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiFuHuaQiWarningBiz.revenueAnomaly(page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-纳税异常 
 * @param req 
 * @param res 
 */
async function getFuHuaQiTPAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiFuHuaQiWarningBiz.fuHuaQiTPAnomaly(page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-团队异常 
 * @param req 
 * @param res 
 */
async function getTeamAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiFuHuaQiWarningBiz.teamAnomaly(page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-孵化器风险预警-概览
 * @param req 
 * @param res 
 */
async function guanWeiHuiEnterpriseWarningOverView(req, res) {

    let result = await guanWeiHuiEnterpriseWarningBiz.enterpriseWarningData();

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-企业风险预警-营收
 * @param req 
 * @param res 
 */
async function getEnterpriseBussinessAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiEnterpriseWarningBiz.bussinessAnomaly(page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-企业风险预警-纳税
 * @param req 
 * @param res 
 */
async function getEnterpriseTXPAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiEnterpriseWarningBiz.enterpriseTXPAnomaly(page);

    res.success(result);
}


/**
 * 管理后台-数字看板-张江看板-企业风险预警-团队
 * @param req 
 * @param res 
 */
async function getEnterpriseTeamAnomaly(req, res) {
    let reqConf = {
        page: 'Number'
    };
    const NotMustHaveKeys = [];
    let { page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await guanWeiHuiEnterpriseWarningBiz.teamAnomaly(page);

    res.success(result);
}