/**
 * 孵化器月度填报表 
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 * occupancyRate 取%号前的数据 例如 填报数据为80%  库中数据为80
 * name 为系统生成 此月填报上一月内容 即2月填报时 name中月份为1月  2023-02-06 确定此需求
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';

const monthTableSchema = new Schema({
    taskId:{type:String, index:true},//任务id
    name:String,//任务名称
    fuHuaQiUscc:String,//任务所属孵化器id
    occupancyRate:Number,//出租率 单位为%
    /**不下发字段 */
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
    month:{type:Number, index:true},//数据填报月份
    year:{type:Number, index:true},//数据填报年份
    isUpdate:{type:Boolean, default:false},
    submitTime:Number,//提交时间
});

var monthTableModel;
export function initModel(){
    monthTableModel = baseDB.model('monthTable', monthTableSchema);
    monthTableModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await monthTableModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 通过taskId 获取此次任务添加的月度列表
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @returns {}
 */
export async function findmonthTableListByTaskId(taskId:string) {
    return await monthTableModel.find({taskId, isUpdate:true});
}


/**
 * 通过taskId 获取此次月度任务
 * 支持.save方法保存对象修改
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @returns {}
 */
export async function findMonthTableByTaskId(taskId:string) {
    let monthTableInfo = await monthTableModel.selectOnceData({taskId});
    return monthTableInfo;
}


/**
 * 孵化器月度填报 删除报表
 * @param uscc 孵化器统一信用代码
 * @param name 表名称
 */
export async function deleteReport(uscc:string, name:string) {
    return await monthTableModel.deleteOne({fuHuaQiUscc:uscc, name}).exec();
}


/**
 * 分页查询符合条件的月度任务列表
 * @param selectParam  查询参数
 * @param skipNum 跳过数量
 * @returns []符合条件的月度列表
 */
export async function findMonthTableListToPage(selectParam:object, skipNum:number) {
    return await monthTableModel.find(selectParam).skip(skipNum).limit(10);
}



/**
 * 查询符合条件的月度任务列表
 * @param selectParam  查询参数
 * @param skipNum 跳过数量
 * @returns []符合条件的月度列表
 */
export async function findMonthTableList(selectParam:object) {
    return await monthTableModel.find(selectParam);
}



/**
 * 获取符合条件的月度任务列表数据量
 * @param selectParam  查询参数
 * @returns count 数据量
 */
export async function findMonthTableListCount(selectParam:object) {
    return await monthTableModel.find(selectParam).countDocuments();
}


/**
 * 创建月度任务
 * @param tableList 任务列表 
 */
export async function createMonthTableToList(tableList:object) {
    await monthTableModel.insertMany(tableList);
}


/**
 * 分组获取特定年月的已提交的出租率总合
*/
export async function statsFuHuaQiMonthDataCount(year:number, month:number) {
    let statsList = await monthTableModel.aggregate([
        {"$match":{year, month, draftLock:true}},
        {"$group":{_id:"$month", count:{"$sum":"$occupancyRate"} }}
    ]);

    return statsList[0] ? statsList[0].count : 0;
}


/**
 * 获取某月填报的最低的出租率
 * @param year 
 * @param month 
 * @returns 
 */
export async function getLowOccupancyRateForMonthData(year:number, month:number) {
    return await monthTableModel.find({year, month, draftLock:true}).sort({occupancyRate:1}).limit(5);
}