/**
 * 拆分返回结果配置
 * 使用场景：逻辑层中需要返回数据给客户端的地方
 * 限制：使用端不同不能共用一份配置
 */


/**
 * 使用端:   管理后台
 * 场景:     孵化器基础数据列表
 * 备注:     导出和列表共用一份配置
 */
export const FuHuaQiBaseListConfig = {
    name:{key:"名称"},
    operationName:{key:"运营机构名称  不可修改"},
    uscc:{key:"统一信用代码 也是登录账号 不可修改"},
    virtualEnterpriseNum:{key:"虚拟企业数量"},
    logonTime:{key:"注册时间", changeDate:true},
    incubatedAcreage:{key:"在孵面积(㎡)"},
    acreageTotal:{key:"孵化器总面积(㎡)"},
    acreagePersonalUse:{key:"孵化器自用面积(㎡)"},
    lv:{key:"孵化器级别"},
    identificationTime:{key:"认定时间", changeDate:true},
    industry:{key:"领域[]"},
    institutionalNature:{key:"机构性质"},
    liaison:{key:"联系人"},
    liaisonPhone:{key:"联系电话"},
    personInCharge:{key:"负责人"},
    personInChargePhone:{key:"负责人联系电话"},
    hatchingGround:{key:"经备案孵化场地"},
    foundingTeam:{key:"创业团队"},
    operationModel:{key:"运营模式"},
    foundingTeamType:{key:"创业团队类型"}
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     添加新注册企业信息
 * 备注:     回显
 */
export const EnterpriseInfoConfig = {
    draftId:{key:"草稿箱id"},
    name:{key:"企业名称"}, //
    uscc:{key:"统一信用代码"}, //
    industry:{key:"领域"},//
    logonTime:{key:"注册时间", changeDate:true},//
    firstIncubationTime:{key:"首次入孵时间", changeDate:true},//
    isNaturalPersonHolding:{key:"是否自然人控股企业"},//
    logonAddress:{key:"注册地址"},//
    operatingAddress:{key:"经营地址"},//
    leasedArea:{key:"租赁面积（平方米）"},
    mainBusiness:{key:"主营业务"},//主营业务
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     添加迁入企业信息
 * 备注:     回显
 */
export const EnterpriseMoveInInfoConfig = {
    draftId:{key:"草稿箱id"},
    name:{key:"企业名称"}, //
    uscc:{key:"统一信用代码"}, //
    industry:{key:"领域"},//
    logonTime:{key:"注册时间", changeDate:true},//
    firstIncubationTime:{key:"首次入孵时间", changeDate:true},//
    isNaturalPersonHolding:{key:"是否自然人控股企业"},//
    logonAddress:{key:"注册地址"},//
    operatingAddress:{key:"经营地址"},//
    leasedArea:{key:"租赁面积（平方米）"},
    timeOfImmigration:{key:"迁入时间", changeDate:true},//
    oldLogonAddress:{key:"迁入前注册地址"},//
    mainBusiness:{key:"主营业务"},//主营业务
};



/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     企业融资信息
 * 备注:     回显
 */
export const EnterpriseFinancingInfoConfig = {
    uscc:{key:"统一信用代码"},//
    name:{key:"企业名称"},//
    logonAddress:{key:"注册地址"},//
    operatingAddress:{key:"经营地址"},//
    financingAmount:{key:"融资金额(万元)"},//
    investmentInstitutionsName:{key:"投资机构名称"},//
    timeToObtainInvestment:{key:"获得投资时间", changeDate:true},//
    fuHuaQiInvestment:{key:"孵化器是否投资"},
    fuHuaQiInvestmentAmount:{key:"孵化器投资金额(万元)"},//
    fuHuaQiInvestmentStyle:{key:"孵化器投资方式"},//
    financingRounds:{key:"融资轮次"}
};


/**
 * 使用端:   管理后台
 * 场景:     在孵企业列表
 * 备注:     导出和列表共用一份配置
 */
export const EnterpriseListConfig = {
    name:{key:"企业名称"},
    createTime:{key:"入库时间 不可修改", changeDate:true},
    fuhuaqiUscc:{key:"孵化器统一信用代码 不可修改 这里显示运营机构的名称"},
    uscc:{key:"统一信用代码 也是登录账号 不可修改"},
    industry:{key:"行业领域[] 最多 选择三个"},
    logonTime:{key:"注册时间", changeDate:true},
    firstIncubationTime:{key:"首次入孵时间", changeDate:true},
    timeOfImmigration:{key:"迁入时间", changeDate:true},
    isNaturalPersonHolding:{key:"是否自然人控股"},
    oldLogonAddress:{key:"迁入前注册地址", isAdd:true},
    logonAddress:{key:"注册地址", isAdd:true},
    operatingAddress:{key:"经营地址", isAdd:true},
    leasedArea:{key:"租赁面积（平方米）"},
    isCreate:{key:"新注册/新迁入"},
    mainBusiness:{key:"主营业务"},//主营业务
    state:{key:"孵化状态"},
    virtualCause:{key:"虚拟孵化模式"},
    intellectualProperty:{key:"知识产权"},
    qualification:{key:"企业资质"},
    cycxfx:{key:"创业创新方向"},
    cycsrbj:{key:"创业创始人背景"}
};


/**
 * 使用端:   管理后台
 * 场景:     迁出企业列表
 * 备注:     导出和列表共用一份配置
 */
export const EnterpriseMoveOutListConfig = {
    name:{key:"企业名称"},
    moveOutTime:{key:"迁出时间", changeDate:true},
    moveOutType:{key:"迁出类型"},
    moveOutCause:{key:"迁出原因"},
    fuHuaQiUscc:{key:"前所属孵化器"},
    industry:{key:"行业领域[] 最多 选择三个"},
    createTime:{key:"入库时间 不可修改", changeDate:true},
    uscc:{key:"统一信用代码 也是登录账号 不可修改"},
    mainBusiness:{key:"主营业务"},//主营业务
    logonTime:{key:"注册时间", changeDate:true},
    timeOfImmigration:{key:"迁入时间", changeDate:true},
    oldLogonAddress:{key:"迁入前注册地址"},
    firstIncubationTime:{key:"首次入孵时间", changeDate:true},
    isNaturalPersonHolding:{key:"是否自然人控股"},
    logonAddress:{key:"注册地址"},
    operatingAddress:{key:"经营地址"},
    leasedArea:{key:"租赁面积（平方米）"},
};





/**
 * 使用端:   管理后台
 * 场景:     企业融资信息列表
 * 备注:     导出和列表共用一份配置
 */
export const FinancingListConfig = {
    uscc:{key:"企业统一信用代码"},
    name:{key:"企业名称"},
    logonAddress:{key:"注册地址", isAdd:true},
    operatingAddress:{key:"经营地址", isAdd:true},
    financingAmount:{key:"融资金额(万元)"},
    investmentInstitutionsName:{key:"投资机构名称"},
    timeToObtainInvestment:{key:"获得投资时间", changeDate:true},
    fuHuaQiInvestment:{key:"孵化器是否投资"},
    fuHuaQiInvestmentAmount:{key:"孵化器投资金额(万元)"},
    fuHuaQiInvestmentStyle:{key:"孵化器投资方式"},
    createTime:{key:"录入时间 不可修改", changeDate:true},
    industry:{key:"行业领域[] 最多 选择三个"},
    logonTime:{key:"注册时间", changeDate:true},
    financingRounds:{key:"融资轮次"}
}


/**
 * 使用端:   管理后台
 * 场景:     账号信息列表
 * 备注:     
 */
export const FuHuaQiListConfig = {
    operationName:{key:"运营机构名称 不可修改"},
    uscc:{key:"营业执照"},
    liaison:{key:"联系人"},
    liaisonPhone:{key:"联系人电话"},
    personInChargePhone:{key:"负责人联系电话"},
    userState:{key:"账号状态"}
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器月度报表
 * 备注:     回显
 */
export const MonthConfig = {
    name:{key:"任务名称"},
    occupancyRate:{key:"出租率"},
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     主界面基础数据
 * 备注:     
 */
export const FuHuaQiHomeDataConfig = {
    incubatedAcreage:{key:"在孵面积"},
    acreageTotal:{key:"孵化器总面积"},
    acreagePersonalUse:{key:"孵化器自用面积"},
    name:{key:"名称"},
    lv:{key:"孵化器级别"},
    institutionalNature:{key:"机构性质"}
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器详细数据
 * 备注:     回显
 */
export const FuHuaQiBaseDataConfig = {
    virtualEnterpriseNum:{key:"虚拟企业数量"},
    incubatedAcreage:{key:"在孵面积"},
    acreageTotal:{key:"孵化器总面积"},
    acreagePersonalUse:{key:"孵化器自用面积"},
    hatchingGround:{key:"经备案孵化场地"},
    // isProfessionalTechnology:{key:"是否专业技术平台"},
    // professionalTechnologyName:{key:"专业技术平台名称"},
    // professionalTechnologyCreateTime:{key:"专业技术平台时间"},
    // professionalTechnologyAmount:{key:"专业技术平台投资金额"},
    // isCooperation:{key:"是否与第三方机构合作"},
    // cooperationInstitutions:{key:"合作机构名称"},
    enterpriseTotal:{key:"累计企业"}
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     机构信息数据
 * 备注:     回显
 */
export const OrganizationBaseDataConfig = {
    name:{key:"名称"},
    operationName:{key:"运营机构名称"},
    uscc:{key:"统一信用代码"},
    logonTime:{key:"注册时间", changeDate:true},
    lv:{key:"孵化器级别"},
    identificationTime:{key:"认定时间", changeDate:true},
    industry:{key:"孵化领域"},
    institutionalNature:{key:"机构性质"},
    operationModel:{key:"运营模式"},//新加
    foundingTeam:{key:"创始团队"},//新加
    foundingTeamType:{key:"创始团队类型"},//新加
    liaison:{key:"联系人"},
    liaisonPhone:{key:"联系电话"},
    // personInCharge:{key:"负责人"}, 2.0去掉了
    // personInChargePhone:{key:"负责人联系电话"}, 2.0去掉了
    operationModelDes:{key:"运营模式描述"},
    introduction:{key:"简介"} //2.3新加
    // hatchingGround:{key:"经备案孵化场地"}
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     我的企业列表(实体 虚拟)
 * 备注:
 */
export const MyEnterpriseDataConfig = {
    name:{key:"名称"},
    uscc:{key:"统一信用代码"},
    state:{key:"孵化器状态"},
    leasedArea:{key:"租赁面积"},
    
}


/**
 * 使用端：  小程序端【孵化器入口】
 * 场景：    我的企业列表中的企业详情
 * 备注： 回显
 */
export const MyEnterpriseBaseDataConfig = {
    name: {key:"企业名称"},
    uscc:{key:"统一信用代码" },
    industry:{key:"领域"},
    mainBusiness:{key:"主营业务"},
    logonTime:{key:"注册时间"},
    firstIncubationTime:{key:"首次入孵时间"},
    isNaturalPersonHolding:{key:"是否自然人控股企业"},
    logonAddress:{key:"注册地址"},
    operatingAddress:{key:"经营地址"},
}


/**=================================================================小程序 => 企业入口配置 */

/**
 * 使用端：  小程序端【企业入口】
 * 场景：   企业融资列表  和 修改的回显
 * 备注： 这里截取的是 financinginfo 表 而不是 financing 表
 */
export const EnterpriseFinancingListDataConfig = {
    id:{key:"唯一标识"},
    financingRounds:{key:"融资轮次"},
    financingAmount:{key:"融资金额_万元"},
    investmentInstitutionsName:{key:"投资机构名称"},
    timeToObtainInvestment:{key:"获得投资时间"},
    fuHuaQiInvestment:{key:"孵化器是否投资"},
    fuHuaQiInvestmentAmount:{key:"孵化器投资金额_万元"},
    fuHuaQiInvestmentStyle:{key:"孵化器投资方式"},
}


/**
 * 使用端：  小程序端【企业入口】
 * 场景：   企业信息回显
 * 备注：
 */
export const EnterpriseBaseConfig = {
    name:{key:"企业名称"}, 
    uscc:{key:"统一信用代码"}, 
    industry:{key:"领域"},
    logonTime:{key:"注册时间"},
    firstIncubationTime:{key:"首次入孵时间"},
    isNaturalPersonHolding:{key:"是否自然人控股企业"},
    logonAddress:{key:"注册地址"},
    operatingAddress:{key:"经营地址"},
    mainBusiness:{key:"主营业务"},
    securePhon:{key:"安全手机号"},
}


/**
 * 使用端：  小程序端【企业入口】
 * 场景：   创始团队回显
 * 备注：
 */
export const EnterpriseInitialTeamConfig = {
    id:{key:"id标识"},
    type:{key:"创始团队人才类型"},
    memberName:{key:"成员姓名"},
    memberSex:{key:"成员性别"},
    memberAge:{key:"成员年龄  出生年月时间戳"},
    memberDEGREE:{key:"成员最高学历"},
    memberSchool:{key:"毕业学校"},
    des:{key:"履历描述"},
}


/**
 * 使用端：  小程序端【企业入口】
 * 场景：   企业的团队信息申报回显
 * 备注：
 */
export const EnterpriseTeamConfig = {
    doctor:{key:"博士"},
    master:{key:"硕士"},
    undergraduate:{key:"本科"},
    juniorCollege:{key:"专科"},
    other:{key:"其他"},
    studyAbroad:{key:"留学人数"},
    graduates:{key:"应届毕业生"},
}


/**
 * 使用端：  管理后台端
 * 场景：   经营数据
 * 备注：
 */
export const EnterpriseBusinessDataConfig = {
    name:{key:"企业名称"},
    year:{key:"年份"},
    quarter:{key:"季度"},
    BI:{key:"营业收入"},
    RD:{key:"研发投入"},
    TXP:{key:"纳税"},
}


/**
 * 使用端：  管理后台端
 * 场景：   企业填报融资数据
 * 备注：
 */
export const EnterpriseFinancingDataConfig = {
    name:{key:"企业名称"},
    financingRounds:{key:"融资轮次"},
    financingAmount:{key:"融资金额(万元)"},
    investmentInstitutionsName:{key:"投资机构名称"},
    timeToObtainInvestment:{key:"获得投资时间",  changeDate:true},
    fuHuaQiInvestment:{key:"孵化器是否投资"},
    fuHuaQiInvestmentAmount:{key:"孵化器投资金额(万元)"},
    fuHuaQiInvestmentStyle:{key:"孵化器投资方式"}
}


/**
 * 使用端：  管理后台端
 * 场景：   创始团队列表
 * 备注：
 */
export const EnterpriseInitialTeamDataListConfig = {
    name:{key:"企业名称"},
    type:{key:"创始团队人才类型"},
    memberName:{key:"成员姓名"},
    memberSex:{key:"成员性别"},
    memberAge:{key:"成员年龄  出生年月时间戳", changeDate:true},
    memberDEGREE:{key:"成员最高学历"},
    memberSchool:{key:"毕业学校"},
    des:{key:"履历描述"},
}


/**
 * 使用端：  小程序端【孵化器入口】
 * 场景：   经营数据待审核列表
 * 备注：
 */
export const BusinessDataUnauditedListConfig = {
    id:{key:"id标识"},
    type:{key:"创始团队人才类型"},
    memberName:{key:"成员姓名"},
    memberSex:{key:"成员性别"},
    memberAge:{key:"成员年龄  出生年月时间戳"},
    memberDEGREE:{key:"成员最高学历"},
    memberSchool:{key:"毕业学校"},
    des:{key:"履历描述"},
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器经营数据回显
 */
export const FuHuaQiBusinessDataInfoConfig = {
    TR:{key:"综合收入"},
    ROR:{key:"投资收入"},
    RR:{key:"租金收入"},
    FS:{key:"财政补贴"},
    MIS:{key:"其他"},
    NP:{key:"净利润"},
    TP:{key:"纳税"},
}