
export enum ERRORENUM {
    未找到数据,
    参数错误,
    不能重复提交任务,
    请完善信息,
    该企业已存在,
    数据无更新,
    该孵化器月度填报已存在,
    该企业当月数据已存在,
    该报表需要填写本月内容后提交,
    密码错误,
    密码不允许有特殊字符,
    不能重复修改密码,
    身份验证失败,
    非法登录,
    身份验证过期,
    密码长度不能超过24个字符,
    账号不存在,
    已入库的数据不能删除,
    任务不存在,
    该企业不存在,
    该孵化器账号信息已存在,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    统一社会信用代码不合法,
    统一社会信用代码重复,
    系统错误,
    该任务已提交,
    无法操作其他孵化器的企业,
    请填入其他原因,
    账号非绑定关系,
    code无效,
    频繁操作请稍后再试,
    高风险等级用户,
    系统繁忙,
    绑定失败,
    发送验证码次数超限制,
    发送验证码频率过快,
    没有联系人,
    号码与主体不一致,
    验证码错误,
    验证码失效,
    验证码过期,
    不能修改过期任务数据,
    短信发送失败,
    地址数据不完整,
    字数超过200限制,
    只能修改本企业信息,
    请勿重复提交填报数据,
    未提交填报数据不能修改,
    未提交填报数据,
    不在填报范围之内,
    只能删除本企业信息,
    不能补录已有数据,
    请正确填报数据,
    不能重复创建填报,
    请先创建填报数据,
    重复通过填报数据,
    请先选择是否拥有,
    请先关闭该资讯,
    请不要重复开启资讯,
    该孵化器经营数据填报已存在,
    未填报数据不能删除,
    已提交的数据不能进行操作,
    请先填报数据,
    该报表需要填写本季度内容后提交,
    只能上传png或jpg图片,
    文件上传失败,
    系统错误请联系管理员,
    企业审批中请下个自然月登录,
    缺少关键参数导致修改失败,
    不合规操作,
    未填安全手机号无法修改密码
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
    code无效 = 40029,
    频繁操作请稍后再试 = 45011,
    高风险等级用户 = 40226,
    系统繁忙 = 40227
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}