/**
 * 校验表单参数配置 【小程序】【企业】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */




/**
 * 使用端:   小程序端【企业入口】
 * 场景:     创建新的融资信息
 * 备注:     所有参数为必填
 */
export const EnterpriseCreateFinancingDataConfig = {
    financingRounds:{type:"Number"},//融资轮次
    financingAmount:{type:"Number"}, //融资金额_单位 万元
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间时间戳
    fuHuaQiInvestment:{type:"Boolean"},//孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number"},//孵化器投资金额_单位 万元
    fuHuaQiInvestmentStyle:{type:"Number"},//孵化器投资方式
}

/**
 * 使用端:   小程序端【企业入口】
 * 场景:     创建新的融资信息选择了孵化器投资
 * 备注:     
 */
export const EnterpriseCreateFinancingParamSubConfig = {
    fuHuaQiInvestmentAmount:{type:"Number"},
    fuHuaQiInvestmentStyle:{type:"Number"}
}



/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改融资信息
 * 备注:     所有参数为必填
 */
export const EnterpriseUpdateFinancingDataConfig = {
    id:{type:"String"},//id
    financingRounds:{type:"Number"},//融资轮次
    financingAmount:{type:"Number"}, //融资金额_单位 万元
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间时间戳
    fuHuaQiInvestment:{type:"Boolean"},//孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number"},//孵化器投资金额_单位 万元
    fuHuaQiInvestmentStyle:{type:"Number"},//孵化器投资方式
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改企业信息
 * 备注:     所有参数为必填
 */
export const EnterpriseUpdateBaseDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
    securePhon:{type:"String"},//安全手机号
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     申报经营数据
 * 备注:     所有参数为必填
 */
export const EnterpriseAddBusinessDataConfig = {
    BI:{type:"Number"},//营业收入
    RD:{type:"Number"},//研发投入
    TXP:{type:"Number"},//纳税
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     申报团队信息数据
 * 备注:     所有参数为必填
 */
export const EnterpriseAddTeamDataConfig = {
    doctor:{type:"Number"},//博士
    master:{type:"Number"},//硕士
    undergraduate:{type:"Number"},//本科
    juniorCollege:{type:"Number"},//专科
    other:{type:"Number"},//其他
    studyAbroad:{type:"Number"},//留学人数
    graduates:{type:"Number"},//应届毕业生
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改企业创始团队
 * 备注:     所有参数为必填
 */
export const InitialTeamUpdateConfig = {
    id:{type:"String"},//标识
    type:{type:"Number"},//创始团队人才类型
    memberName:{type:"String"},//成员姓名
    memberSex:{type:"Number"},//成员性别
    memberAge:{type:"Number"},//成员年龄  出生年月时间戳
    memberDEGREE:{type:"Number"},//成员最高学历
    memberSchool:{type:"String"},//毕业学校
    des:{type:"String"},//履历描述
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     企业修改资质信息
 * 备注:     所有参数为必填
 */
export const EnterpriseQualificationUpdateConfig = {
    isHighTech:{type:"Boolean"},
    highTechMs:{type:"Number"},//高新技术
    isZjtx:{type:"Boolean"},
    zjtxMs:{type:"Number"},//专精特新
    isXjrpy:{type:"Boolean"},
    xjrpyMs:{type:"Number"},//小巨人培育
    isXjr:{type:"Boolean"},
    xjrMs:{type:"Number"},//小巨人
    beOnTheMarket:{type:"[Number]", notMustHave:true},//上市情况
    isBeOnTheMarket:{type:"Boolean"}
}

