/**
 * 校验表单参数配置 【管理后台端】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */

/**
 * 使用端:   管理后台
 * 场景:     新增孵化器账号
 * 备注:     所有参数为必填
 */
export const FuHuaQiUserConfig = {
    operationName:{type:"String" },//运营机构名称
    uscc:{type:"String" },//营业执照 
    personInChargePhone:{type:"String" },//负责人手机号
    personInCharge:{type:"String" }//负责人 
};


/**
 * 场景: 数据看板管委会修改孵化器信息
 */
export const GuanWeiHuiChnageFuHuaQiBaseConfig = {
    name:{type:"String"},// {key:"名称"},
    operationName:{type:"String"},// {key:"运营机构名称"},
    uscc:{type:"String"},// {key:"统一信用代码"},
    incubatedAcreage:{type:"Number"},//在孵面积(㎡)
    acreageTotal:{type:"Number"},//孵化器总面积(㎡)
    acreagePersonalUse:{type:"Number"},//孵化器自用面积(㎡)
    logonTime:{type:"Number"},// {key:"注册时间", changeDate:true},
    lv:{type:"Number"},// {key:"孵化器级别"},
    identificationTime:{type:"Number"},// {key:"认定时间", changeDate:true},
    industry:{type:"[Number]"},// {key:"孵化领域"},
    institutionalNature:{type:"Number"},// {key:"机构性质"},
    liaison:{type:"String"},// {key:"联系人"},
    liaisonPhone:{type:"String"},// {key:"联系电话"},
    personInCharge:{type:"String"},// {key:"负责人"}, 
    introduction:{type:"String",  notMustHave:true},//孵化器简介      
};