/**
 * 埋点主要逻辑
 */

import { ENTERPRISENODEENUM, FUHUAQINODEENUM, POINTTYPEENUM } from "../config/pointConfig";
import { logError } from "../util/log";
import { post } from "../util/request";

const Sign = "xxxx8901231kldosdjkfsdlk";

export async function addPoint(pointType:number, uid:string, pointId:number, p1, p2?, p3?) {
    let url = 'http://localhost:7078/point/';

    let pointInfo:any = {uid, ct:new Date().valueOf() };

    if (pointType == POINTTYPEENUM.企业 ) {
        url += "enterprise/add";
        if (pointId != ENTERPRISENODEENUM.政策速递 && pointId != ENTERPRISENODEENUM.创始团队 ) {
            pointInfo.pid = pointId;
        }
        /**组合埋点信息 */
        if (pointId >= ENTERPRISENODEENUM.经营数据补录_营业收入 &&  pointId <= ENTERPRISENODEENUM.经营数据补录_纳税) {
            /**经营数据不必保存旧值 */
            pointInfo.p1 = JSON.stringify(p1);
            post(url, {pointInfo, pointId}, {sign:Sign});
        } else if (pointId == ENTERPRISENODEENUM.政策速递) {
            pointInfo.p1 = p1;
            post(url, {pointInfo, pointId}, {sign:Sign});
        } else if (pointId == ENTERPRISENODEENUM.进入首页) {
            post(url, {pointInfo, pointId}, {sign:Sign});
        } else {
            /**数组类型 or 对象类型 */
            let oldData;
            let newData;
            if (typeof p1 == "object") {
                oldData = JSON.stringify(p1);
                newData = JSON.stringify(p2);
            } else if (typeof p1 == "number") {
                oldData = p1 + '';
                newData = p2 + '';
            } else {
                oldData = p1;
                newData = p2;
            }

            if (oldData != newData) {
                pointInfo.p1 = oldData;
                pointInfo.p2 = newData;
                if (ENTERPRISENODEENUM.基本信息_经营地址 == pointId || ENTERPRISENODEENUM.基本信息_行业领域 == pointId) {
                    pointInfo.p3 = p3;
                }
                post(url, {pointInfo, pointId}, {sign:Sign});
            }
        }
    } else {
        /**孵化器埋点 */
        url += "fuhuaqi/add";
        if (pointId == FUHUAQINODEENUM.政策速递 ) {
            pointInfo.p1 = p1;
            post(url, {pointInfo, pointId}, {sign:Sign});
        } else if (pointId == FUHUAQINODEENUM.进入首页) {
            post(url, {pointInfo, pointId}, {sign:Sign});
        } else {
            pointInfo.pid = pointId;
            let oldData;
            let newData;
            if (typeof p1 == "object") {
                oldData = JSON.stringify(p1);
                newData = JSON.stringify(p2);
            } else if (typeof p1 == "number") {
                oldData = p1 + '';
                newData = p2 + '';
            } else {
                oldData = p1;
                newData = p2;
            }
            /**机构资质要加类型埋点 */
            if (pointId >= 2 || pointId<= 7) {
                pointInfo.pt = p3;
            }
            
            if (oldData != newData) {
                pointInfo.p1 = oldData;
                pointInfo.p2 = newData;
                post(url, {pointInfo, pointId}, {sign:Sign});
            }

        }
    }

    
}


/**
 * 获取埋点数据
 * @param type 类型 
 * @param pointId 埋点id
 * @param param 参数
 * @returns 
 */
export async function getPointDataByParam(type:number, pointId:number, param) {
    let url = 'http://localhost:7078/point/query';
    let result:any = await post(url, {type, pointId, param}, {sign:Sign});

    if (!result.success || result.code != 200) {
        logError(url, "请求失败", JSON.stringify(result) );
        console.log(url, "请求失败", JSON.stringify(result));
        return [];
    }
    return result.data.dataList || [];
}