/**
 * 政策速递
 */

import moment = require("moment");
import * as informationData from "../../data/guanWeiHui/information";
import { FUHUAQINODEENUM, POINTTYPEENUM } from "../../config/pointConfig";
import { addPoint } from "../point";


/**
 * 获取资讯列表
 * 
 * @param uscc 预留好 后期做推荐的参数
 * @param selectTitle 
 * @param page 分页
 * @returns 
 */
export async function getInformationList(uscc:string, selectTitle:string, page:number) {
    let selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    let informationList = await informationData.selectInformationByParamToPage(selectParam, (page-1) * 10 );
    let count = await informationData.selectInformationByParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;

    let dataList = [];

    informationList.forEach((info) => {
        let { id, title,createTimeMs, source, coverImg } = info;
        
        dataList.push({title, id, createTime:moment(createTimeMs).format("MM/DD"),source, url:`/policy/${coverImg}`});
        
    });

    return {dataList, count, pageCount};
}


/**
 * 获取过期资讯列表
 * 
 * @param uscc 预留好 后期做推荐的参数
 * @param selectTitle 模糊查询标题
 * @param page 分页
 * @returns 
 */
export async function getOutOfDateInformationList(uscc:string, selectTitle:string, page:number) {
    let selectParam = {"$or":[{closeTimeMs: {"$lt":new Date().valueOf()} }, {state:false}] };
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    let informationList = await informationData.selectInformationByParamToPage(selectParam, (page-1) * 10 );
    let count = await informationData.selectInformationByParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;
    let dataList = [];

    informationList.forEach((info) => {
        let { id, title,createTimeMs, source, coverImg } = info;
        
        dataList.push({title, id, createTime:moment(createTimeMs).format("MM/DD"),source, url:`/policy/${coverImg}`});
        
    });

    return {dataList, count, pageCount};
}


/**
 * 获取资讯详情
 * @param uscc 
 * @param id 标识
 */
export async function getOnceinformation(uscc:string, id:string) {
    let baseData = await informationData.selectInformationDataById(id );

    let reuslt = {
        title:baseData.title,
        desc:baseData.desc,
        source:baseData.source,
        createTime:moment(baseData.createTimeMs).format("MM/DD")
    };

    addPoint(POINTTYPEENUM.孵化器, uscc, FUHUAQINODEENUM.政策速递, id);
    return {infomation:reuslt};
}


/**
 * 获取资讯标题
 * 小程序端首页使用  孵化器端和企业端共用
 * @returns 
 */
export async function getInformationTitleList() {
    let selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
    let baseData = await informationData.selectOnceInformationByParamToParam(selectParam) || {title:""};

    return {title:baseData.title};
}