/**
 * 小程序端  孵化器入口 提醒主要逻辑
 * 作者：lxm
 */

import { TEAM } from "../../../config/enum";
import { findFuHuaQiByUSCC } from "../../../data/fuHuaQi/fuhuaqi";


/**
 * 数据提醒列表
 * @param uscc 孵化器统一信用代码
 */
export async function getDataImprovementList(uscc:string) {
    let fuhuaqiInfo = await findFuHuaQiByUSCC(uscc);
  
    /**校验我的数据 */
    let myData = [];//我的数据
    const MyDataConfig = {
        incubatedAcreage:"在孵面积",
        acreageTotal:"孵化器总面积",
        acreagePersonalUse:"孵化器自用面积",
    };
    for (let key in MyDataConfig) {
        if (key == "hatchingGround") {
            if (!fuhuaqiInfo[key] || !fuhuaqiInfo[key].length) myData.push(MyDataConfig[key]);
        } else {
            if (!fuhuaqiInfo[key]) myData.push(MyDataConfig[key]);
        }
    }
    /**校验 我的信息 */
    let myInformation = [];
    const MyInformationConfig = {
        name:"名称",
        logonTime:"注册时间",
        lv:"孵化器级别",
        identificationTime:"孵化器认定时间",
        industry:"孵化领域",
        institutionalNature:"机构性质",
        operationModel:"运营模式",
        liaison:"联系人",
        liaisonPhone:"联系电话",
        introduction:"孵化器简介"
    };
    for (let key in MyInformationConfig) {
        if (key == "industry" || key == "operationModel" ) {
            if (!fuhuaqiInfo[key] || !fuhuaqiInfo[key].length) myInformation.push(MyInformationConfig[key]);
        } else {
            if (!fuhuaqiInfo[key]) myInformation.push(MyInformationConfig[key]);
        }
    }
    if (fuhuaqiInfo.foundingTeamType != TEAM.无) {
        if (!fuhuaqiInfo.foundingTeam || !fuhuaqiInfo.foundingTeam.length) myInformation.push("孵化器创始团队");
    }

    let title = "数据完善提醒";

    return {haveRemind:myData.length>0 || myInformation.length>0, title, myData, myInformation};
}