/**
 * 张江以外布局 逻辑
 * 作者：lxm
 * 
 */

import * as fuhuaqiData from "../../../../data/fuHuaQi/fuhuaqi";
import { getRandomId } from "../../../../tools/system";
import * as zjBeyondLayoutData  from "../../../../data/fuHuaQi/instituQualify/zjBeyondLayout";
import { changeEnumValue } from "../../../../util/verificationEnum";
import { ZJBEYONDLAYOUTOPERATIONMODE } from "../../../../config/enum";
import { addPoint } from "../../../point";
import * as pointConfig from "../../../../config/pointConfig";
import { BizError } from "../../../../util/bizError";
import { ERRORENUM } from "../../../../config/errorEnum";


/**
 * 创建 张江以外布局信息
 * @param uscc 孵化器统一信用代码
 * @param city 布局城市
 * @param area 空间面积
 * @param operationMode 运营模式
 * @returns 
 */
export async function createZJBeyondLayout(uscc:string, city:string, area:number, operationMode:number) {
    let fuHuaQiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);

    let id = getRandomId(uscc);
    await zjBeyondLayoutData.addData(id, uscc, fuHuaQiInfo.name, city, area, operationMode);

    let pointData = {city, area, operationMode};
    addPoint(pointConfig.POINTTYPEENUM.孵化器, uscc, pointConfig.FUHUAQINODEENUM.机构资质_张江以外布局, pointData, null, pointConfig.OPERATETYPEENUM.添加 );

    return {isSuccess:true};
}


/**
 * 修改 张江以外布局信息
 * @param uscc 孵化器统一信用代码
 * @param id 信息标识
 * @param city 布局城市
 * @param area 空间面积
 * @param operationMode 运营模式
 * @returns 
 */
export async function updateZJBeyondLayout(uscc:string, id:string, city:string, area:number, operationMode:number) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    let oldData = {
        city:dataInfo.city,
        area:dataInfo.area,
        operationMode:dataInfo.operationMode,
    };
    let newData = {city, area, operationMode};
    addPoint(pointConfig.POINTTYPEENUM.孵化器, uscc, pointConfig.FUHUAQINODEENUM.机构资质_张江以外布局, oldData, newData, pointConfig.OPERATETYPEENUM.修改 );

    dataInfo.city = city; 
    dataInfo.area = area; 
    dataInfo.operationMode = operationMode; 

    await dataInfo.save();

    return {isSuccess:true};
}


/**
 * 回显 张江以外布局信息
 * @param id 信息标识
 * @returns 
 */
export async function selectZJBeyondLayout(id:string) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);

    let layoutData = {
        city:dataInfo.city,
        area:dataInfo.area,
        operationMode:dataInfo.operationMode
    };

    return {layoutData} 
}


/**
 * 删除 张江以外布局信息
 * @param id 信息标识
 * @returns 
 */
export async function deleteZJBeyondLayout(uscc:string, id:string) {
    let dataInfo = await zjBeyondLayoutData.findOneData(id);
    if (uscc != dataInfo.uscc) throw new BizError(ERRORENUM.参数错误, "修改张江以外布局信息时", `${uscc}尝试修改${dataInfo.uscc}的信息`);

    let oldData = {
        city:dataInfo.city,
        area:dataInfo.area,
        operationMode:dataInfo.operationMode,
    };
    addPoint(pointConfig.POINTTYPEENUM.孵化器, uscc, pointConfig.FUHUAQINODEENUM.机构资质_张江以外布局, oldData, null, pointConfig.OPERATETYPEENUM.删除 );

    await zjBeyondLayoutData.deleteDataById(id);

    return {isSuccess:true} 
}


/**
 * 获取 张江以外布局信息 列表
 * @param uscc 孵化器统一信用代码
 * @returns 
 */
export async function getZJBeyondLayoutListData(uscc:string) {
    let registerList = await zjBeyondLayoutData.findListDataByParam({uscc});

    let dataList = [];
    registerList.forEach(info => {
        dataList.push({
            id:info.id,
            city:info.city,
            area:info.area,
            operationMode:changeEnumValue(ZJBEYONDLAYOUTOPERATIONMODE, info.operationMode)
        });
    });

    return {dataList, title:"张江以外布局情况"}
}
