/**
 * 管理后台 -> 数据看板 -> 张江看板 -> 企业风险预警
 */

import moment = require("moment");
import { statsBusinessCount } from "../../../../data/enterprise/quarterTask/businessdata";
import { statsEnterpriseTeamCountByNull } from "../../../../data/enterprise/quarterTask/team";


/**
 * 企业预警 概览
 */
export async function enterpriseWarningData() {
    let revenueCount = await getBussinessAnomalyCount();//营收数据
    let tpxCount = await getEnterpriseTXPAnomalyCount();//纳税异常数
    let teamCount = await getTeamAnomalyCount();//团队异常数

    return {revenueCount, tpxCount, teamCount};
}


/**
 * 营收数据异常
 * @param page 
 * @returns 
 */
export async function bussinessAnomaly(page:number) {
    let {declarationQuarter, declarationYear} = getDeclarationTime();

    let param:any = {"$and":[{BI:0}, {"$or":[{isSubmit:true}, {fhqIsSubmit:true}] }]};
    if (declarationQuarter - 1 == 0 ) { /**跨年运算 */
        param["$and"].push({
            "$or":[
                {year:declarationYear, quarter:declarationQuarter},
                {year:declarationYear-1, quarter:4}
            ]
        });
    } else {
        param["$and"].push({year:declarationYear});
        param["$and"].push({quarter:{"$gte":declarationQuarter-1}});
    }

    /**param格式预期 = {"$and":[{"$or":[{},{}] }], {"$or":[{}, {}] }, {}} */

    let warnData = await statsBusinessCount(param);
    let warnList = [];
    warnData.forEach(info => {
        warnList.push({name:info._id, bcos:"多次填报为0"});
    });

    let count = warnList.length;
    let dataList = warnList.splice((page-1)*5, page*5);
    let pageCount = Math.ceil(count/5);

    return {count, pageCount, dataList};
}

async function getBussinessAnomalyCount() {
    let {declarationQuarter, declarationYear} = getDeclarationTime();

    let param:any = {"$and":[{BI:0}, {"$or":[{isSubmit:true}, {fhqIsSubmit:true}] }]};
    if (declarationQuarter - 1 == 0 ) { /**跨年运算 */
        param["$and"].push({
            "$or":[
                {year:declarationYear, quarter:declarationQuarter},
                {year:declarationYear-1, quarter:4}
            ]
        });
    } else {
        param["$and"].push({year:declarationYear});
        param["$and"].push({quarter:{"$gte":declarationQuarter-1}});
    }

    /**param格式预期 = {"$and":[{"$or":[{},{}] }], {"$or":[{}, {}] }, {}} */

    let warnData = await statsBusinessCount(param);
    

    return warnData.length;
}


/**
 * 企业纳税异常数据
 * @returns 
 */
export async function enterpriseTXPAnomaly(page:number) {
    let {declarationQuarter, declarationYear} = getDeclarationTime();

    let param:any = {"$and":[{TXP:0}, {"$or":[{isSubmit:true}, {fhqIsSubmit:true}] }]};
    if (declarationQuarter - 1 == 0 ) { /**跨年运算 */
        param["$and"].push({
            "$or":[
                {year:declarationYear, quarter:declarationQuarter},
                {year:declarationYear-1, quarter:4}
            ]
        });
    } else {
        param["$and"].push({year:declarationYear});
        param["$and"].push({quarter:{"$gte":declarationQuarter-1}});
    }

    /**param格式预期 = {"$and":[{"$or":[{},{}] }], {"$or":[{}, {}] }, {}} */

    let warnData = await statsBusinessCount(param);
    let warnList = [];
    warnData.forEach(info => {
        warnList.push({name:info._id, bcos:"多次填报为0"});
    });

    let count = warnList.length;
    let dataList = warnList.splice((page-1)*5, page*5);
    let pageCount = Math.ceil(count/5);

    return {count, pageCount, dataList};
}

async function getEnterpriseTXPAnomalyCount() {
    let {declarationQuarter, declarationYear} = getDeclarationTime();

    let param:any = {"$and":[{TXP:0}, {"$or":[{isSubmit:true}, {fhqIsSubmit:true}] }]};
    if (declarationQuarter - 1 == 0 ) { /**跨年运算 */
        param["$and"].push({
            "$or":[
                {year:declarationYear, quarter:declarationQuarter},
                {year:declarationYear-1, quarter:4}
            ]
        });
    } else {
        param["$and"].push({year:declarationYear});
        param["$and"].push({quarter:{"$gte":declarationQuarter-1}});
    }

    /**param格式预期 = {"$and":[{"$or":[{},{}] }], {"$or":[{}, {}] }, {}} */

    let warnData = await statsBusinessCount(param);
    return warnData.length;
}


/**
 * 团队异常
 * @param page 
 * @returns 
 */
export async function teamAnomaly(page:number) {
    let {declarationQuarter, declarationYear} = getDeclarationTime();
    let list = await statsEnterpriseTeamCountByNull(declarationYear, declarationQuarter);
    let rankList = [];
    list.forEach(info => {
        rankList.push({name:info.name, count:0, bcos:"填报为0" });
    });
    
    let count = rankList.length;
    let dataList = rankList.splice((page-1)*5, page*5);
    let pageCount = Math.ceil(count/5);

    return {count, pageCount, dataList};
}

async function getTeamAnomalyCount() {
    let {declarationQuarter, declarationYear} = getDeclarationTime();
    let list = await statsEnterpriseTeamCountByNull(declarationYear, declarationQuarter);
    return list.length;
}

function getDeclarationTime() {
    let thisYear = new Date().getFullYear();
    let thisQuarter = moment().quarter();//当月填报季度
    if ( (thisQuarter - 1) < 1 ) {
        thisYear = moment().subtract(1, 'years').year();
        thisQuarter = 4;
    } else thisQuarter = thisQuarter - 1;
    return {declarationYear:thisYear, declarationQuarter:thisQuarter};
}
