/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
const md5 = require("md5");


/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


export function randomId(tableName:string) {
    let randomStr = `${tableName}_${new Date().valueOf()}_${Math.ceil(Math.random()*100000)}`;
    return md5(randomStr);
}

export function getMySqlMs(time?) {
    time = time || new Date().valueOf();
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}

export function successResult() {
    return {isSuccess:true}
}
