import * as asyncHandler from 'express-async-handler'
import { eccReqParamater } from '../util/verificationParam';
import * as diKuaiBiz from '../biz/diKuai';
import * as userBiz from '../biz/user';
import * as zhongYangBiz from '../biz/zhongYang';
import * as nongziBiz from '../biz/nongzi';
import * as nongShiBiz from '../biz/nongShi';
import * as publicRouters from './public';
import * as caiShouBiz from '../biz/caiShou';
import * as xiaoShouBiz from '../biz/xiaoShou';
import { checkUserToken } from '../middleware/user';
import * as dataOutBiz from '../biz/dataOut';

export function setRouter(httpServer){
    /**地块 */
    httpServer.post('/zjnt/xcx/dikuai/add', checkUserToken,  asyncHandler(dikuai_add));//添加
    httpServer.post('/zjnt/xcx/dikuai/info', checkUserToken,  asyncHandler(dikuai_info));//回显
    httpServer.post('/zjnt/xcx/dikuai/list', checkUserToken, asyncHandler(dikuai_list));//列表
    httpServer.post('/zjnt/xcx/dikuai/all', checkUserToken, asyncHandler(dikuai_all));//全部地块列表
    httpServer.post('/zjnt/xcx/dikuai/update', checkUserToken, asyncHandler(dikuai_update));//更新
    httpServer.post('/zjnt/xcx/dikuai/xuanze/list', checkUserToken, asyncHandler(xuanze_dikuai_list));//可用
    httpServer.post('/zjnt/xcx/dikuai/kecaishou/list', checkUserToken, asyncHandler(xuanze_kecaishou_list));//可采收

    /**种养 */
    httpServer.post('/zjnt/xcx/zhongyang/dangqian/list', checkUserToken, asyncHandler(zhongyang_dangqian_list));//当前列表
    httpServer.post('/zjnt/xcx/zhongyang/jilu/list', checkUserToken, asyncHandler(zhongyang_jilu_list));//种养记录
    httpServer.post('/zjnt/xcx/zhongyang/add', checkUserToken, asyncHandler(zhongyang_add));//添加种养

    /**农资 */
    httpServer.post('/zjnt/xcx/nongzi/list', checkUserToken, asyncHandler(nongzi_list));
    httpServer.post('/zjnt/xcx/nongzi/add', checkUserToken, asyncHandler(nongzi_add));

    /**农事 */
    httpServer.post('/zjnt/xcx/nongshi/list', checkUserToken, asyncHandler(nongshi_list));
    httpServer.post('/zjnt/xcx/nongshi/add', checkUserToken, asyncHandler(nongshi_add));

    /**采收 */
    httpServer.post('/zjnt/xcx/caishou/list', checkUserToken, asyncHandler(caishou_list));
    httpServer.post('/zjnt/xcx/caishou/add', checkUserToken, asyncHandler(caishou_add));

    /**销售 */
    httpServer.post('/zjnt/xcx/xiaoshou/list', checkUserToken, asyncHandler(xiaoshou_list));
    httpServer.post('/zjnt/xcx/xiaoshou/add', checkUserToken, asyncHandler(xiaoshou_add));

    /**首页 */
    httpServer.post('/zjnt/xcx/home/top', checkUserToken, asyncHandler(home_top));
    httpServer.post('/zjnt/xcx/home/chonghai', checkUserToken, asyncHandler(home_chonghai));
    httpServer.post('/zjnt/xcx/home/statis/top', checkUserToken, asyncHandler(home_statis_top));//首页统计顶部
    httpServer.post('/zjnt/xcx/home/statis/chanliang', checkUserToken, asyncHandler(home_statis_chanliang));//产量
    httpServer.post('/zjnt/xcx/home/statis/xiaoshou', checkUserToken, asyncHandler(home_statis_xiaoshou));//销售
    httpServer.post('/zjnt/xcx/home/statis/bottom', checkUserToken, asyncHandler(home_statis_bottom));//底部

    /**登录登出 */
    httpServer.post('/zjnt/xcx/user/login', asyncHandler(user_login));//登录
    httpServer.post('/zjnt/xcx/user/logout', checkUserToken, asyncHandler(user_logout));//登出

    httpServer.post('/zjnt/xcx/dataout/zzzmj', asyncHandler(data_out));//
    httpServer.post('/zjnt/xcx/dataout/guiyu', asyncHandler(data_out_guiyu));//

    

    /**公用 */
    publicRouters.setRouter(httpServer);
}

async function data_out(req, res) {
    let result = await dataOutBiz.getDataOut();
    res.success(result);
}

async function data_out_guiyu(req, res) {
    let result = await dataOutBiz.getGuiYuOut();
    res.success(result);
}

/**================================================================首页 */

async function home_statis_chanliang(req, res) {
    let reqConf = {type:'Number'};
    let { type } = eccReqParamater(reqConf, req.body);
    let result = await userBiz.homePageStatisChanLiang(type);
    res.success(result);
}

async function home_statis_xiaoshou(req, res) {
    let result = await userBiz.homePageStatisXiaoShou();
    res.success(result);
}

async function home_top(req, res) {
    const UserInfo = req.userInfo;
    let result = await userBiz.homePageTop(UserInfo);
    res.success(result);
}

async function home_chonghai(req, res) {
    const UserInfo = req.userInfo;
    let result = await userBiz.homePageChongHai(UserInfo);
    res.success(result);
}

async function home_statis_top(req, res) {
    const UserInfo = req.userInfo;
    let result = await userBiz.homePageStatisTop(UserInfo);
    res.success(result);
}

async function home_statis_bottom(req, res) {
    const UserInfo = req.userInfo;
    let result = await userBiz.homePageStatisBottom(UserInfo);
    res.success(result);
}


/**================================================================登录登出 */

async function user_login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let { loginId, pwd } = eccReqParamater(reqConf, req.body);

    let result = await userBiz.userLogin(loginId, pwd);
    
    res.success(result);
}

async function user_logout(req, res) {
    let userInfo = req.userInfo;

    let result = await userBiz.userLogout(userInfo);
    
    res.success(result);
}


/**================================================================地块选择列表 */

async function xuanze_kecaishou_list(req, res) {
    const UserInfo = req.userInfo;
    let reqConf = { zhongYangType:'Number'};
    let { zhongYangType } = eccReqParamater(reqConf, req.body);
    let result = await diKuaiBiz.keCaiShouList(zhongYangType);
    res.success(result);
}

async function xuanze_dikuai_list(req, res) {
    const UserInfo = req.userInfo;
    let reqConf = { zhongYangType:'Number'};
    let { zhongYangType } = eccReqParamater(reqConf, req.body, ["zhongYangType"]);
    let result = await diKuaiBiz.keXuanDiKuaiList(zhongYangType);
    res.success(result);
}


/**================================================================销售 */

async function xiaoshou_list(req, res) {
    let reqConf = {selectStr:"String", plantType:'Number', quXiang:'Number', operationTime:"Number" };
    const NotMustHaveKeys = ["selectStr", "dId", "nzType", "operationTime"];
    let {selectStr, quXiang, plantType, operationTime } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo; 
    let result = await xiaoShouBiz.xiaoShouList(selectStr, quXiang, plantType, operationTime);
    res.success(result);
}

async function xiaoshou_add(req, res) {
    let reqConf = {param: 'Object'};
    const NotMustHaveKeys = [];
    let { param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await xiaoShouBiz.addXiaoShou(UserInfo, param);
    res.success(result);
}


/**================================================================采收 */

async function caishou_list(req, res) {
    let reqConf = {selectStr:"String", dId: 'String', plantType:'Number', zhongYangType:"Number", operationTime:"Number" };
    const NotMustHaveKeys = ["selectStr", "dId", "nzType", "operationTime", "plantType"];
    let {selectStr, dId, plantType, operationTime, zhongYangType } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;
    let result = await caiShouBiz.caiShouList(zhongYangType, selectStr, dId, plantType, operationTime);
    res.success(result);
}

async function caishou_add(req, res) {
    let reqConf = {param: 'Object'};
    const NotMustHaveKeys = [];
    let { param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await caiShouBiz.addCaiShou(UserInfo, param);
    res.success(result);
}


/**================================================================农事 */

async function nongshi_list(req, res) {
    let reqConf = {selectStr:"String", dId: 'String', nsType:'Number', operationTime:"Number" };
    const NotMustHaveKeys = ["selectStr", "dId", "nzType", "operationTime"];
    let {selectStr, dId, nsType, operationTime } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;
    let result = await nongShiBiz.nongShiList(selectStr, dId, nsType, operationTime);
    res.success(result);
}

async function nongshi_add(req, res) {
    let reqConf = {param: 'Object'};
    const NotMustHaveKeys = [];
    let { param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await nongShiBiz.addNongShi(UserInfo, param);
    res.success(result);
}



/**================================================================农资 */

async function nongzi_list(req, res) {
    let reqConf = {selectStr:"String", dId: 'String', nzType:'Number', useTime:"Number" };
    const NotMustHaveKeys = ["selectStr", "dId", "nzType", "useTime"];
    let {selectStr, dId, nzType, useTime } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;
    let result = await nongziBiz.nongZiList(selectStr, dId, nzType, useTime);
    res.success(result);
}

async function nongzi_add(req, res) {
    let reqConf = {param: 'Object'};
    const NotMustHaveKeys = [];
    let { param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await nongziBiz.addNongZi(UserInfo, param);
    res.success(result);
}


/**================================================================种养 */

async function zhongyang_dangqian_list(req, res) {
    let reqConf = {selectStr:"String", plantType: 'Number'};
    const NotMustHaveKeys = ["selectStr"];
    let { plantType, selectStr } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await zhongYangBiz.zhongYangDangQianList(plantType, selectStr);
    res.success(result);
}

async function zhongyang_add(req, res) {
    let reqConf = {param: 'Object'};
    const NotMustHaveKeys = [];
    let { param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await zhongYangBiz.addZhongYang(UserInfo, param);
    res.success(result);
}

async function zhongyang_jilu_list(req, res) {
    let reqConf = {selectStr:"String", plantType:"Number", plantTime:"Number", dId:"String", zhongYangType:"Number"};
    const NotMustHaveKeys = ["selectStr", "plantType", "plantTime", "dId" ];
    let { selectStr, plantType, plantTime, dId, zhongYangType } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await zhongYangBiz.zhongYangJiLu(zhongYangType, selectStr, plantType, plantTime, dId);
    res.success(result);
}

/**================================================================地块 */

async function dikuai_add(req, res) {
    let reqConf = {param: 'Object', plotType:"Number" };
    const NotMustHaveKeys = [];
    let { plotType, param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await diKuaiBiz.addDiKuai(UserInfo, plotType, param);
    res.success(result);
}


async function dikuai_info(req, res) {
    let reqConf = {dId: 'String' };
    const NotMustHaveKeys = [];
    let { dId } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await diKuaiBiz.diKuaiInfo(dId);
    res.success(result);
}

async function dikuai_list(req, res) {
    let reqConf = {plotType:"Number", selectStr: 'String', code:"String", purpose:'Number', area:"Number" };
    const NotMustHaveKeys = ["selectStr", "code", "purpose", "area"];
    let { plotType, selectStr, code, purpose, area} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;
    
    let result = await diKuaiBiz.diKuaiList(plotType, selectStr, code, purpose, area);
    res.success(result);
}

async function dikuai_all(req, res) {
    let reqConf = {plotType:"Number" };
    const NotMustHaveKeys = [];
    let { plotType} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;
    
    let result = await diKuaiBiz.allDiKuaiList(plotType);
    res.success(result);
}

async function dikuai_update(req, res) {
    let reqConf = {param: 'Object', dId:"String", plotType:"Number" };
    const NotMustHaveKeys = [];
    let { plotType, dId, param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    const UserInfo = req.userInfo;

    let result = await diKuaiBiz.updateDiKuai(UserInfo, plotType, dId, param);
    res.success(result);
}