/**
 * 公共资源路由
 */
import * as asyncHandler from 'express-async-handler';
import * as enumConfig from '../config/enum';

const config = {
    "/zjnt/xcx/public/plottype":enumConfig.PLOTTYPE,//地块类型
    "/zjnt/xcx/public/purpose":enumConfig.PURPOSE,//用途
    "/zjnt/xcx/public/planttype":enumConfig.PLANTTYPE,//种植种类
    "/zjnt/xcx/public/arearange":enumConfig.AREARANGE,//面积范围
    "/zjnt/xcx/public/nongzitype":enumConfig.NONGZITYPE,//农资类型
    "/zjnt/xcx/public/nongshitype":enumConfig.NONGSHITYPE,//农事类型
    "/zjnt/xcx/public/zhongyangtype":enumConfig.ZHONGYANGTYPE,//种养类型
    "/zjnt/xcx/public/zhongyangtype/shuichan":enumConfig.SHUICHAN,//水产
    "/zjnt/xcx/public/zhongyangtype/huahui":enumConfig.HUAHUITYPE,//花卉
    "/zjnt/xcx/public/zhongyangtype/liangshi":enumConfig.LIANGSHI,//粮食
    "/zjnt/xcx/public/zhongyangtype/shucai":enumConfig.SHUCAI,//蔬菜
    "/zjnt/xcx/public/xiaoshouquxiang":enumConfig.XIAOSHOUQUXIANG,//销售去向
}


export function setRouter(httpServer) {
    for (let modelKey in config) {
        httpServer.post(modelKey, asyncHandler(getEnumItf(config[modelKey])));
    }
}


/**
 * 
 * @param req 
 * @param res 
 */
function getEnumItf(enumCof) {
    return async function (req, res) {
        let dataList = [];
        for (let key in enumCof) {
            let anyKey:any = key;
            if (isNaN(anyKey)) {
                dataList.push({key, value:enumCof[key]});
            }
        }
        res.success({dataList});
    }
   
}