const Sequelize = require('sequelize');

export const TablesConfig = [
    {
        tableNameCn:'地块表',
        tableName:'dikuai',
        schema:{
            dId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            size: {type:Sequelize.DECIMAL, allowNull:false}, //地块大小
            useSize: {type:Sequelize.DECIMAL, allowNull:false}, //使用大小
            code:{type:Sequelize.STRING(255)}, //编号
            name: {type:Sequelize.STRING(255)}, //地块名称
            plotType:{type:Sequelize.INTEGER}, //地块类型 【枚举】  PLOTTYPE
            purpose:{type:Sequelize.STRING(255)},//用途 【枚举】 PURPOSE
            createUser:{type:Sequelize.STRING(255)}, //创建人
        },
        association: []
    },
    {
        tableNameCn:'用户表',
        tableName:'users',
        schema:{
            uId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
           
        },
        association: []
    },
    {
        tableNameCn:'种植表',
        tableName:'zhongzhi',
        schema:{
            zId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            size:{type:Sequelize.DECIMAL, allowNull:false}, //种植面积
            plantType:{type:Sequelize.INTEGER}, //种植种类【枚举】 PLANTTYPE
            dId:{type:Sequelize.STRING(255)}, //地块id
            plantTime:{type:Sequelize.DATE}, //种植时间 
            uId:{ype:Sequelize.STRING(255)},//用户id
            isEnd:{type:Sequelize.INTEGER}//是否结束  0=否 1=是
        },
        association: []
    },
    {
        tableNameCn:'农资',
        tableName:'nongzi',
        schema:{
            nzId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            nzType:{type:Sequelize.INTEGER}, //农资类型 
            dIdList:{type:Sequelize.STRING(255)}, //地块id
            plantType:{type:Sequelize.INTEGER}, //作物名称【枚举】 PLANTTYPE
            count:{type:Sequelize.DECIMAL, allowNull:false},//用量
            useTime:{type:Sequelize.DATE},//使用时间
            ct:{type:Sequelize.DATE},//创建时间
        },
        association: []
    },
    {
        tableNameCn:'农事',
        tableName:'nongshi',
        schema:{
            nsId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            nsType:{type:Sequelize.INTEGER}, //农事类型
            dIdList:{type:Sequelize.STRING(255)}, //地块id
            operationTime:{type:Sequelize.DATE},//操作时间
            ct:{type:Sequelize.DATE},//创建时间

        },
        association: []
    },
    {
        tableNameCn:'采收',
        tableName:'caishou',
        schema:{
            csId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            dIdList:{type:Sequelize.STRING(255)}, //地块id
            plantType:{type:Sequelize.INTEGER}, //种植种类【枚举】 PLANTTYPE
            weight:{type:Sequelize.DECIMAL},//采收重量
            operationTime:{type:Sequelize.DATE},//采收时间
            ct:{type:Sequelize.DATE},//创建时间
        },
        association: []
    },
    {
        tableNameCn:'销售',
        tableName:'xiaoshou',
        schema:{
            xsId: {
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            plantType:{type:Sequelize.INTEGER}, //种植种类【枚举】 PLANTTYPE
            quXiang:{type:Sequelize.INTEGER},//销售去向
            weight:{type:Sequelize.DECIMAL},//重量
            operationTime:{type:Sequelize.DATE},//销售时间
            ct:{type:Sequelize.DATE},//创建时间
        },
        association: []
    },


]; 