/**
 * 种养
 */

import moment = require("moment");
import { TABLENAME } from "../config/dbEnum";
import { DiKuaiConfig, ZhongYangConfig } from "../config/eccParam";
import { PLANTTYPE, PLOTTYPE, ZHONGYANGTYPE } from "../config/enum";
import * as zhongzhiData from "../data/zhongzhi";
import * as dikuaiData from "../data/dikuai";
import { randomId, successResult } from "../tools/system";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";

/**
 * 种养列表
 * @param plantType 种养类型
 * @param selectStr 
 * @returns 
 */
export async function zhongYangDangQianList(zhongYangType:number, selectStr:string) {
    let funName = `当前种养列表`;
    eccEnumValue(funName, 'zhongYangType', ZHONGYANGTYPE, zhongYangType);

    let param = {
        plantType:{"$gte":zhongYangType, "$lt":zhongYangType+99},
        isEnd:0
    };
    let zyList = await zhongzhiData.selectToParam( param );
    
    let typeMap = {};
    zyList.forEach(info => {
        let {plantType} = info;
        typeMap[plantType] = {value:plantType, key:changeEnumValue(PLANTTYPE, plantType)};
    });
    let dataList = Object.values(typeMap);

    return {dataList};
}


/**
 * 添加种养
 * @param reqUser 
 * @param param 
 * @returns 
 */
export async function addZhongYang(reqUser, param) {
    let funName = `添加种养`;
    eccFormParam(funName, ZhongYangConfig, param);
    eccEnumValue(funName, "plantType", PLANTTYPE, param.plantType);

    //校验地块大小是否符合扣除
    let dkInfo = await dikuaiData.selectOne({dId:param.dId});
    if (!dkInfo || !dkInfo.dId) throw new BizError(ERRORENUM.地块不存在);
    if (dkInfo.nullSize < param.size) throw new BizError(ERRORENUM.地块大小不足);

    let addInfo = {
        zId:randomId(TABLENAME.种植表),
        size:param.size,//种植大小
        plantType:param.plantType,//
        dId:param.dId,//地块id
        plantTime:param.plantTime,//种植时间
        uId:reqUser.userId,
        isEnd:0,
        ct:new Date().valueOf()
    };

    await zhongzhiData.addData(addInfo);

    dkInfo.nullSize = dkInfo.size - param.size;
    dkInfo.useSize = dkInfo.useSize + param.size;
    await dkInfo.save();

    return successResult();
}


/**
 * 种养记录
 * @param zhongYangType 
 * @param selectStr 
 * @param plantType 
 * @param plantTime 
 * @param dId 
 * @returns 
 */
export async function zhongYangJiLu(zhongYangType:number, selectStr:string, plantType:number, plantTime:number, dId:string) {
    let funName = `种养记录`;
 
    let param:any = { plantType:{"$gte":zhongYangType, "$lt":zhongYangType+99} };
    if (plantType) {
        eccEnumValue(funName, "plantType", PLANTTYPE, plantType);
        param.plantType = plantType;
    }
    if (dId) {
        param.dId = dId;
    }
    if (plantTime) {
        let selectStartTime = moment(plantTime).startOf('month').valueOf();
        let selectEndTime = moment(plantTime).endOf("month").valueOf();
        param.plantTime = {"$gt":selectStartTime, "$lt":selectEndTime};
    }
    
    /**获取地块名称 */
    let dikuaiList = await dikuaiData.selectToParam({});
    let diKuaiMap = {};
    dikuaiList.forEach(info => {
        let {dId, code} = info;
        diKuaiMap[dId] = code;
    });

    let dbList = await zhongzhiData.selectToParam(param);
    let dataList = [];
    dbList.forEach(info => {
        dataList.push({
            plantType:changeEnumValue(PLANTTYPE, info.plantType),
            size:info.size,
            code:diKuaiMap[info.dId],
            plantTime:moment(info.plantTime).format("YYYY-MM-DD")
        })
    });

    return {dataList};
}