/**
 * 用户
 */


import { ERRORENUM } from "../config/errorEnum";
import { findUserInfoByLoginId, findUserInfoByUserId } from "../data/users";
import { getPwdMd5, getToken, successResult } from "../tools/system";
import { BizError } from "../util/bizError";
import * as diKuaiData from "../data/dikuai";
import * as zhongZhiData from "../data/zhongzhi";
import { selectChanLiangOfMonth, selectChanLiangOfzuoWu } from "../data/caishou";
import { changeEnumValue } from "../util/verificationEnum";
import { PLANTTYPE } from "../config/enum";
import { selectXiaoShouOfMonth, selectXiaoShouOfzuoWu } from "../data/xiaoshou";


/**
 * 登录
 * @param loginId 
 * @param pwd 
 * @returns 
 */
export async function userLogin(loginId:string, pwd:string) {
    let userInfo:any = await findUserInfoByLoginId(loginId);
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.账号不存在, loginId);

    let checkPwd = getPwdMd5(loginId, pwd); 
    if (userInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);

    let token = getToken(loginId);
    
    let resultUserInfo = {
        loginId:userInfo.loginId,
        name: userInfo.name,
        userId:userInfo.userId,
        token:token,
    };

    userInfo.token = token;
    userInfo.tokenMs = new Date().valueOf();

    await userInfo.save();
    
    return {dataInfo:resultUserInfo};
}



/**
 * 登出
 * @param userInfo 
 */
export async function userLogout(reqUserInfo) {
    let userInfo = await findUserInfoByUserId(reqUserInfo.userId);

    userInfo.token = getToken(userInfo.loginId);
    userInfo.tokenMs = new Date().valueOf();

    await userInfo.save();

    return successResult(); 
}


/**
 * 首页
 * @param userInfo 
 * @returns 
 */
export async function homePageChongHai(userInfo) {
    // let param = {
    //     state:SOLVESTATE.待解决,//待解决
    // };
    // let visitCount = await visitData.findDataCount(param);

    // let enterpriseCount = await findEnterpriseCountByParam({RAS:RAS.续存});
    // let industryCount = await statisIndustryEnterprise();

    return {dataInfo:{title:"当前无虫害预警", state:0}};
}


/**
 * 首页 顶部
 * @param userInfo 
 * @returns 
 */
export async function homePageTop(userInfo) {

    return {dataInfo:{
        name:userInfo.name,
        title:userInfo.position
    }};
}


/**
 * 首页-统计页 顶部
 * @param userInfo 
 * @returns 
 */
export async function homePageStatisTop(userInfo) {
    //面积
    let {totalSize, totalUseSize} = await diKuaiData.diKuaiSizeCount();
    let rate = 0;
    if (totalSize && totalUseSize) {
        Math.round(totalUseSize/totalSize*100);
    }

    //品种
    let zhongZhiTypeList = await zhongZhiData.pingZhongCount();

    let dataInfo = {
        diKuaiCount : totalSize,
        zhongYangCount : totalUseSize,
        zhongYangPinZhong : zhongZhiTypeList.length,
        shiYongLv:rate,
    };

    return {dataInfo};
}



/**
 * 首页-统计页 底部
 * @param userInfo 
 * @returns 
 */
export async function homePageStatisBottom(userInfo) {

    let dataInfo = {
        congYe : 0,
        zhuanYe : 0,
        chanYeZhuTi : 0,
    };

    return {dataInfo};
}



/**
 * 统计页产量统计
 * @param type 
 * @returns 
 */
export async function homePageStatisChanLiang(type:number) {
    
    //产量 时间分
    let monthDBList = await selectChanLiangOfMonth();
    let distinctMap = {};
    let count = 0;
    monthDBList.forEach(info => {
        let {year, month, totalWeight} = info;
        
        let strKey = "";
        if (type == 1) {//年
            strKey = year;
        } else if (type == 2) {//季度
            let quarter = 1;
            if (month >= 10) quarter = 4;
            else if (month >= 7) quarter = 3;
            else if (month >= 4) quarter = 2;
            strKey = `${year}_${quarter}`;
        } else {//月
            strKey = `${year}_${month}`;
        }

        if (!distinctMap[strKey]) distinctMap[strKey] = {key:strKey, value:0};
        distinctMap[strKey].value += totalWeight;

        count += totalWeight;
    });
    let nongChanPin = Object.values(distinctMap);

    //农作物产量
    let zuoWuDBList = await selectChanLiangOfzuoWu();
    let zuoWu = [];
    zuoWuDBList.forEach(info => {
        let {_id, totalWeight} = info;
        zuoWu.push({
            key:changeEnumValue(PLANTTYPE, _id),
            value:totalWeight
        });
    });

    let dataInfo = {
        count,
        nongChanPin,
        zuoWu:zuoWu,
    };

    return {dataInfo};
}


/**
 * 统计页销售量统计
 * @param type 
 * @returns 
 */
export async function homePageStatisXiaoShou() {
    let thisYear = new Date().getFullYear();
    //产量
    let monthDBList = await selectXiaoShouOfMonth();
    let distinctMap = {};
    let count = 0;
    let lastYearCount = 0;
    monthDBList.forEach(info => {
        let {year, month, totalWeight} = info;
        
        let strKey = `${year}_${month}`;

        if (!distinctMap[strKey]) distinctMap[strKey] = {key:strKey, value:0};
        distinctMap[strKey].value += totalWeight;

        if (thisYear == year) count += totalWeight;
        else if (year == (thisYear-1)) lastYearCount += totalWeight;
    });

    let xiaoShouList = Object.values(distinctMap);

    let xiaoShouDBList = await selectXiaoShouOfzuoWu();

    let xiaoShou = [];
    xiaoShouDBList.forEach(info => {
        let {_id, totalWeight} = info;
        xiaoShou.push({
            key:changeEnumValue(PLANTTYPE, _id),
            value:totalWeight
        });
    });


    
    let dataInfo = {
        count,//
        mom:Math.round( (count-lastYearCount)/lastYearCount * 1000 )/10,
        xiaoShou:xiaoShouList,
        zuoWu:xiaoShou
    };

    return {dataInfo};
}
