/**
 * 农资
 */

import moment = require("moment");
import { TABLENAME } from "../config/dbEnum";
import { NongZiConfig } from "../config/eccParam";
import { NONGZITYPE, PLANTTYPE } from "../config/enum";
import * as nongziData from "../data/nongzi";
import * as dikuaiData from "../data/dikuai";
import { randomId, successResult } from "../tools/system";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";

/**
 * 添加农资
 * @param reqUser 
 * @param param 
 * @returns 
 */
export async function addNongZi(reqUser, param) {
    let funName = `添加农资`;
    eccFormParam(funName, NongZiConfig, param );
    eccEnumValue(funName, "nzType", NONGZITYPE, param.nzType);
    eccEnumValue(funName, "plantType", PLANTTYPE, param.plantType);
    //确保添加时地块还在
    let dikuaiList = await dikuaiData.selectToParam({});
    let diKuaiMap = {};
    dikuaiList.forEach(info => {
        let {dId, code} = info;
        diKuaiMap[dId] = code;
    });
    if (!diKuaiMap[param.dIdList]) throw new BizError(ERRORENUM.地块不存在, param.dIdList);

    let addInfo = {
        nzId:randomId(TABLENAME.农资),
        nzType:param.nzType,
        dIdList:[param.dIdList],
        plantType:param.plantType,
        count:param.count,
        useTime:param.useTime,
        ct:new Date().valueOf()
    };
    await nongziData.addData(addInfo)

    return successResult();
}


/**
 * 农资列表
 * @param selectStr 
 * @param dId 
 * @param nzType 
 * @param useTime 
 * @returns 
 */
export async function nongZiList(selectStr:string, dId:string, nzType:number, useTime:number) {
    let funName = "农资列表";
    let param:any = {};
    if (nzType) {
        eccEnumValue(funName, "nzType", NONGZITYPE, nzType);
        param.nzType = nzType;
    }
    if (dId) {
        param.dIdList = {"$in":dId};
    }
    if (useTime) {
        let startMs = moment(useTime).startOf("month").valueOf();
        let endMs = moment(useTime).endOf("month").valueOf();
        param.useTime = {"$gt":startMs, "$lt":endMs};
    }

    let dikuaiList = await dikuaiData.selectToParam({});
    let diKuaiMap = {};
    dikuaiList.forEach(info => {
        let {dId, code} = info;
        diKuaiMap[dId] = code;
    });

    let diKuaiList = await nongziData.selectToParam( param );

    let dataList = [];
    diKuaiList.forEach(item => {
        let {nzType, dIdList, plantType, count, useTime } = item;
        let didStr = "";
        dIdList.forEach(dId => {
            didStr += `${diKuaiMap[dId] || "-"}`;
        })
        dataList.push({
            nzType:changeEnumValue(NONGZITYPE, nzType),
            dIdList:didStr,
            plantType:changeEnumValue(PLANTTYPE, plantType),
            count,
            useTime:moment(useTime).format("YYYY-MM-DD")
        });
    });

    return {dataList};
}