/**
 * 地块
 */

import { TABLENAME } from "../config/dbEnum";
import { DiKuaiConfig, YangZhiChiConfig } from "../config/eccParam";
import { AREARANGE, PLANTTYPE, PLOTTYPE, PURPOSE, ZHONGYANGTYPE } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import * as dikuaiData from "../data/dikuai";
import { randomId, successResult } from "../tools/system";
import { BizError } from "../util/bizError";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";


/**
 * 添加地块
 * @param reqUser 
 * @param plotType 
 * @param param 
 * @returns 
 */
export async function addDiKuai(reqUser, plotType, param) {
    let funName = `添加地块`;
    eccEnumValue(funName, "plottype", PLOTTYPE, plotType);

    let purpose = PURPOSE.养殖;
    if (plotType == PLOTTYPE.地块) {
        eccFormParam(funName+changeEnumValue(PLOTTYPE, plotType), DiKuaiConfig, param);
        eccEnumValue(funName, "param=>type", PURPOSE, param.type);
        purpose = param.type;
    } else {
        eccFormParam(funName+changeEnumValue(PLOTTYPE, plotType), YangZhiChiConfig, param);
    }

    let addInfo = {
        dId:randomId(TABLENAME.地块表),
        size:param.size,
        useSize:0,//使用大小默认0
        nullSize:param.size,//初始可使用大小为大小
        code:param.code,
        name:param.code, //地块名称
        plotType,
        purpose,//用途 【枚举】 PURPOSE
        createUser:reqUser.userId,
        ct:new Date().valueOf()
    };
    await dikuaiData.addData(addInfo);

    return successResult();
}

/**
 * 地块信息
 * @param plotType 
 * @param selectStr 
 * @param code 
 * @param purpose 
 * @param area 
 * @returns 
 */
export async function diKuaiInfo(dId:String ) {
    let funName = "地块信息";
   
    let dikuaiInfo = await dikuaiData.selectOne({dId});
    let dataInfo = {
        size:dikuaiInfo.size, 
        dId:dikuaiInfo.dId, 
        type:dikuaiInfo.purpose,
        purpose:changeEnumValue(PURPOSE, dikuaiInfo.purpose),
        code:dikuaiInfo.code
    };

    return {dataInfo}
}


/**
 * 地块列表
 * @param plotType 
 * @param selectStr 
 * @param code 
 * @param purpose 
 * @param area 
 * @returns 
 */
export async function diKuaiList(plotType:number, selectStr:string, code:string, purpose:number, area:number ) {
    let funName = "地块列表";
    eccEnumValue(funName, "plottype", PLOTTYPE, plotType);
   
    let param:any = {plotType};
    if (code) {
        param.code = { "$regex":code };
    }
    if (purpose) {
        eccEnumValue(funName, "purpose", PURPOSE, purpose);
        param.purpose = purpose;
    }
    if (area) {
        eccEnumValue(funName, "area", AREARANGE, area);
        param.size = {"$lte": parseInt(AREARANGE[area].replace("<=", "")) };
    }

    let diKuaiList = await dikuaiData.selectToParam(param);
    let dataList = [];
    diKuaiList.forEach(item => {
        let { size, dId, purpose, code } = item;
        dataList.push({size,dId,type:changeEnumValue(PURPOSE, purpose),code});
    });

    return {dataList}
}


/**
 * 修改地块信息
 * @param reqUser 
 * @param plotType 
 * @param dId 
 * @param param 
 * @returns 
 */
export async function updateDiKuai(reqUser, plotType, dId, param) {
    let funName = `修改地块`;
    eccEnumValue(funName, "plottype", PLOTTYPE, plotType);

    let purpose = PURPOSE.养殖;
    if (plotType == PLOTTYPE.地块) {
        eccFormParam(funName+changeEnumValue(PLOTTYPE, plotType), DiKuaiConfig, param);
        eccEnumValue(funName, "param=>type", PURPOSE, param.type);
        purpose = param.type;
    } else {
        eccFormParam(funName+changeEnumValue(PLOTTYPE, plotType), YangZhiChiConfig, param);
    }

    let dInfo = await dikuaiData.selectOne({dId});
    if (!dInfo || !dInfo.dId) throw new BizError(ERRORENUM.地块不存在);

    dInfo.code = param.code,
    dInfo.size = param.size,
    dInfo.purpose = purpose;

    await dInfo.save();

    return successResult();
}



/**
 * 当前可种植地块
 * @returns 
 */
export async function keXuanDiKuaiList(zhongYangType:number) {
    let param:any = {};
    if (zhongYangType) {
        let purpose = 1;
        if (zhongYangType == ZHONGYANGTYPE.水产) purpose = PURPOSE.养殖;
        else if (zhongYangType == ZHONGYANGTYPE.花卉 ||zhongYangType == ZHONGYANGTYPE.蔬菜 ) purpose = PURPOSE.菜田;
        else if (zhongYangType == ZHONGYANGTYPE.粮食) purpose = PURPOSE.粮田;
        param.nullSize = {"$gt":0};
        param.purpose = purpose;
    }

    console.log("------>", JSON.stringify(param));
   
    let dbList = await dikuaiData.selectToParam(param);

    let dataList = [];

    dbList.forEach(info => {
        let {code, purpose, dId, size} = info;
        dataList.push( {code, purpose:changeEnumValue(PURPOSE, purpose), dId, size});
    });

    return {dataList};
}


/**
 * 当前采收地块列表
 * @returns 
 */
export async function keCaiShouList(zhongYangType:number) {
    let purpose = 1;
    if (zhongYangType == ZHONGYANGTYPE.水产) purpose = PURPOSE.养殖;
    else if (zhongYangType == ZHONGYANGTYPE.花卉 ||zhongYangType == ZHONGYANGTYPE.蔬菜 ) purpose = PURPOSE.菜田;
    else if (zhongYangType == ZHONGYANGTYPE.粮食) purpose = PURPOSE.粮田;
    let param = {useSize:{"$gt":0}, purpose:purpose};

    let dbList = await dikuaiData.selectToParam(param);

    let dataList = [];

    dbList.forEach(info => {
        let {code, purpose, dId, size} = info;
        dataList.push( {code, purpose:changeEnumValue(PURPOSE, purpose), dId, size});
    });

    return {dataList}
}

/**
 * 全部地块列表
 * @param plotType 
 * @param selectStr 
 * @param code 
 * @param purpose 
 * @param area 
 * @returns 
 */
export async function allDiKuaiList(plotType:number ) {
    let funName = "地块列表";
    eccEnumValue(funName, "plottype", PLOTTYPE, plotType);
   
    let param:any = {plotType};

    let diKuaiList = await dikuaiData.selectToParam(param);
    let dataList = [];
    diKuaiList.forEach(item => {
        let { size, dId, purpose, code } = item;
        dataList.push({dId, code});
    });

    return {dataList}
}