/**
 * 数据接口输出
 */

import moment = require("moment");
import { LIANGSHI, NONGZITYPE, PLANTTYPE, PLOTTYPE, XIAOSHOUQUXIANG } from "../config/enum";
import { diKuaiSizeCountByParam } from "../data/dikuai";
import { statisNongZiType, statisNongZiTypeCountByTime } from "../data/nongzi";
import { zhongYangTongJiCount, zhongZhiTongJiCount } from "../data/zhongzhi"
import * as nongshiData from "../data/nongshi"
import * as xiaoshouData from "../data/xiaoshou"
import { changeEnumValue } from "../util/verificationEnum";
import { selectChanLiangOfMonth } from "../data/caishou";

export async function getDataOut() {
    let 种植总面积 = 0;
    let 粮田面积 = 0;
    let 菜田面积 = 0;
    let 作物数量 = 0;

    let zhongZhiList = await zhongZhiTongJiCount();
    let zhongZhiZuoWuList = []; //结果
    zhongZhiList.forEach(info => {
        let {_id, sizeCount} = info;
        种植总面积 += sizeCount;
        if (_id == LIANGSHI.水稻 || _id == LIANGSHI.蚕豆) {
            粮田面积 += sizeCount;
        } else if (_id < 100) {
            菜田面积 += sizeCount;
        }
        if ( !(_id > 100 && _id < 200)) {
            作物数量 += 1;
            zhongZhiZuoWuList.push({key:changeEnumValue(PLANTTYPE, _id), value:sizeCount});
        }
    });

    let diKuaiInfo = await diKuaiSizeCountByParam({plotType:PLOTTYPE.地块});
    let 地块使用率 = 0;
    if (diKuaiInfo.totalSize && diKuaiInfo.totalUseSize) {
        地块使用率 = Math.round(diKuaiInfo.totalUseSize/diKuaiInfo.totalSize * 100);
    }
    let zhongZhiTypeList = [
        {key:"种植总面积", value:种植总面积},
        {key:"菜田面积", value:菜田面积},
        {key:"粮田面积", value:粮田面积},
        {key:"作物数量", value:作物数量},
        {key:"地块使用率", value:地块使用率},
    ]; //结果

    let 农资类型 = await statisNongZiType();
    let 农资情况Map = {};
    农资情况Map[NONGZITYPE.肥料] = {key:changeEnumValue(NONGZITYPE, NONGZITYPE.肥料), value:0};
    农资情况Map[NONGZITYPE.农药] = {key:changeEnumValue(NONGZITYPE, NONGZITYPE.农药), value:0};
    农资情况Map[NONGZITYPE.其他] = {key:changeEnumValue(NONGZITYPE, NONGZITYPE.其他), value:0};
    农资类型.forEach(info => {
        let {_id, count} = info;
        if (农资情况Map[_id]) 农资情况Map[_id].value = count;
    });
    let nongZiList = Object.values(农资情况Map); //结果

    let nongZiAllMonthList = await statisNongZiTypeCountByTime();
    let nongZiCountInfo = {};//肥料用药情况
    nongZiCountInfo[NONGZITYPE.农药] = {};
    nongZiCountInfo[NONGZITYPE.肥料] = {};
//     nongZiAllMonthList = [
//         { "totalWeight" : 15, "year" : 2025, "month" : 1, "nzType" : 2 },
// { "totalWeight" : 23, "year" : 2025, "month" : 2, "nzType" : 1 },
// { "totalWeight" : 10, "year" : 2025, "month" : 3, "nzType" : 1 },
//     ]
    nongZiAllMonthList.forEach(info => {
        let {year, month, nzType, totalWeight} = info;
        if (nongZiCountInfo[nzType]) {
            nongZiCountInfo[nzType][`${year}-${month}`] = totalWeight;
        };
    });
    let 肥料  = [];
    let 用药 = [];
    for (let i = 9; i >= 0; i--) {
        let key = moment().subtract(i, 'months').format("YYYY-M");
        肥料.push({
            key,
            value:nongZiCountInfo[NONGZITYPE.肥料][key] || 0
        });
        用药.push({
            key,
            value:nongZiCountInfo[NONGZITYPE.农药][key] || 0
        });
    }
    let feiliaoyongyaoqingkuang = [ //结果
        {name:"肥料", data:肥料},
        {name:"用药", data:用药},
    ];
 
    let nongShiCount = await nongshiData.selectCountByParam({}); //结果
    let nongshiTyptList = await nongshiData.statisNongShiType();
    let 操作趋势 = {};
    let nongShiList = [];//结果
    nongshiTyptList.forEach(info => {
        let {year, month, count} = info;
        操作趋势[`${year}-${month}`] = count;
    });
    for (let i = 9; i >= 0; i--) {
        let key = moment().subtract(i, 'months').format("YYYY-M");
        nongShiList.push({
            key,
            value:操作趋势[key] || 0
        });
    }


     let monthDBList = await selectChanLiangOfMonth();
    let 作物产量Map = {};
    monthDBList.forEach(info => {
        let {year, month, totalWeight} = info;
        
        let key = `${year}-${month}`;
        if (!作物产量Map[key]) 作物产量Map[key] = 0;
        作物产量Map[key] += totalWeight;
    });


    let 今年 = [];
    let 去年 = [];
    let thisYear = new Date().getFullYear();
    let lastYear = thisYear - 1;
    let 今年产量总数 = 0;
    let 去年产量总数 = 0;
    for (let i =1; i <=12; i++) {
        let thisYearItem = 作物产量Map[`${thisYear}-${i}`] || 0;
        let lastYearItem = 作物产量Map[`${lastYear}-${i}`] || 0;
        今年.push({key: `${thisYear}-${i}`, value:thisYearItem });
        去年.push({key: `${lastYear}-${i}`, value:lastYearItem });
        今年产量总数 += thisYearItem;
        去年产量总数 += lastYearItem;
    }
    let chanLiangList = [ //结果
        {name:"今年", data:今年},
        {name:"去年", data:去年},
    ];

    let 产量年同比 = 0;
    if (今年产量总数 && 去年产量总数)  {
        产量年同比 = Math.round((今年产量总数 - 去年产量总数)/ 去年产量总数*10000)/100
    }
    let chanLiangStatisList = [//结果
        {key:"作物产量", value:今年产量总数},
        {key:"同比", value:产量年同比}
    ];

    let xiaoshouStartMs = moment().subtract(1, "months").startOf('month').valueOf();
    let xiaoshouEndMs = moment().startOf('month').valueOf();
    let xiaoshouDBList = await xiaoshouData.selectToParam({operationTime:{"$gt":xiaoshouStartMs, "$lt":xiaoshouEndMs }});

    let lastMonthXiaoShou = 0;
    let lastMonthXiaoShouMap = {};
    xiaoshouDBList.forEach(info => {
        let {operationTime, weight} = info;
        lastMonthXiaoShou += weight;
        let key = moment(operationTime).format("MM-DD");
        let dayKey = moment(operationTime).format("DD");
        if (!lastMonthXiaoShouMap[key]) lastMonthXiaoShouMap[key] = {key:dayKey, value:0};
        lastMonthXiaoShouMap[key].value += weight;
    });
    let lastMonthXiaoShouList = Object.values(lastMonthXiaoShouMap);//结果

    return {
        zhongZhiZuoWuList,
        zhongZhiTypeList,
        nongZiList,
        feiliaoyongyaoqingkuang,
        nongShiList,
        nongShiCount,
        chanLiangList,
        chanLiangStatisList,
        lastMonthXiaoShou,
        lastMonthXiaoShouList
    }

}


export async function getGuiYuOut() {
    let zhongZhiList = await zhongYangTongJiCount();

    let ymyzsl = [];
    let count = 0;
    let kcMap = {};
    zhongZhiList.forEach(info => {
        let {_id, sizeCount} = info;
        ymyzsl.push({
            key:changeEnumValue(PLANTTYPE, _id),
            value:`${sizeCount}万尾`
        });
        count += sizeCount;
        if (!kcMap[_id]) kcMap[_id] = 0
        kcMap[_id] += (info.sizeCount * 10000);
    });

    let scyz = [
        {key:"养殖面积", value:'0亩'},
        {key:"鱼苗养殖", value:`${count/10000}亿`},
    ];

   

    let xiaoshouList = await xiaoshouData.selectToParam({plantType:{"$gt":100, "$lt":200}});
    let xsjl = [];
    xiaoshouList.forEach(info => {
        let subList = [
            changeEnumValue(PLANTTYPE, info.plantType),
            changeEnumValue(XIAOSHOUQUXIANG, info.quXiang),
            info.weight,
            '尾',
            moment(info.operationTime).format("YYYY-MM-DD")
        ];
        xsjl.push(subList);
        if (kcMap[info.plantType]) {
            kcMap[info.plantType] -= info.weight;
        }
    });

    let kcjlData = [];
    for (let key in kcMap ) {
        if (kcMap[key] > 0) {
            kcjlData.push({
                key:changeEnumValue(PLANTTYPE, parseInt(key)),
                value:`${kcMap[key]}尾`
            })
        }
    }

    return {kcjlData, scyz, ymyzsl, xsjl};
}
