import moment = require("moment");
import { TABLENAME } from "../config/dbEnum";
import { NONGSHITYPE, NONGZITYPE, PLANTTYPE, PLOTTYPE, PURPOSE, SHUCAI, XIAOSHOUQUXIANG } from "../config/enum";
import * as dikuaiData from "../data/dikuai";
import * as usersData from "../data/users";
import { getPwdMd5, md5PwdStr, randomId } from "../tools/system";
import { onceSheetBecomeOfblockData } from "../util/analysisExcel";
import { info } from "console";
import * as zhongzhiData from "../data/zhongzhi";
import * as caishouData from "../data/caishou";
import * as xiaoshouData from "../data/xiaoshou";
import * as nongshiData from "../data/nongshi";
import * as nongziData from "../data/nongzi";
import { changeEnumValue } from "../util/verificationEnum";
const md5 = require("md5");


export async function dataInit() {
  
    // let list = [
    //     {name:"孙伟锋", loginId:"13501917073", userId:randomId("13501917073"), pwd:getPwdMd5("13501917073", md5PwdStr("917073")), position:"总经理、支部书记", phone:"13501917073" },
    //     {name:"奚准", loginId:"13681774690", userId:randomId("13681774690"), pwd:getPwdMd5("13681774690", md5PwdStr("774690")), position:"委员、副总经理", phone:"13681774690" },
    //     {name:"张新华", loginId:"18917398240", userId:randomId("18917398240"), pwd:getPwdMd5("18917398240", md5PwdStr("398240")), position:"副总经理", phone:"18917398240" },
    //     {name:"奚芬", loginId:"13482539885", userId:randomId("13482539885"), pwd:getPwdMd5("13482539885", md5PwdStr("539885")), position:"会计", phone:"13482539885" },
    //     {name:"周礼斌", loginId:"13916920611", userId:randomId("13916920611"), pwd:getPwdMd5("13916920611", md5PwdStr("920611")), position:"党务、办公室", phone:"13916920611" },
    //     {name:"王庵丽", loginId:"13817016377", userId:randomId("13817016377"), pwd:getPwdMd5("13817016377", md5PwdStr("016377")), position:"办公室、出纳", phone:"13817016377" },
    //     {name:"郭忠", loginId:"13817085310", userId:randomId("13817085310"), pwd:getPwdMd5("13817085310", md5PwdStr("085310")), position:"园区管理、水产队", phone:"13817085310" },
    //     {name:"俞晓璐", loginId:"13651822368", userId:randomId("13651822368"), pwd:getPwdMd5("13651822368", md5PwdStr("822368")), position:"园区管理", phone:"13651822368" },
    //     {name:"顾晓云", loginId:"13918083136", userId:randomId("13918083136"), pwd:getPwdMd5("13918083136", md5PwdStr("083136")), position:"网格、办公室", phone:"13918083136" },
    //     {name:"唐秀英", loginId:"13817682215", userId:randomId("13817682215"), pwd:getPwdMd5("13817682215", md5PwdStr("682215")), position:"园区管理、水产队", phone:"13817682215" },
    //     {name:"赵华", loginId:"13601603073", userId:randomId("13601603073"), pwd:getPwdMd5("13601603073", md5PwdStr("603073")), position:"园区管理", phone:"13601603073" },
    //     {name:"郭晓军", loginId:"13917808059", userId:randomId("13917808059"), pwd:getPwdMd5("13917808059", md5PwdStr("808059")), position:"园区管理", phone:"13917808059" },
    //     {name:"王奇勇", loginId:"13681878706", userId:randomId("13681878706"), pwd:getPwdMd5("13681878706", md5PwdStr("878706")), position:"园区管理", phone:"13681878706" },
    //     {name:"乔燕苗", loginId:"13917181512", userId:randomId("13917181512"), pwd:getPwdMd5("13917181512", md5PwdStr("181512")), position:"河道管理", phone:"13917181512" },
    //     {name:"陆雨薇", loginId:"13816303956", userId:randomId("13816303956"), pwd:getPwdMd5("13816303956", md5PwdStr("303956")), position:"林业管理", phone:"13816303956" },
    //     {name:"黄蔓茜", loginId:"18217229710", userId:randomId("18217229710"), pwd:getPwdMd5("18217229710", md5PwdStr("229710")), position:"林业管理", phone:"18217229710" },
    //     {name:"吴昊", loginId:"13761401296", userId:randomId("13761401296"), pwd:getPwdMd5("13761401296", md5PwdStr("401296")), position:"林业养护", phone:"13761401296" },
    //     {name:"赵志俊", loginId:"18516205482", userId:randomId("18516205482"), pwd:getPwdMd5("18516205482", md5PwdStr("205482")), position:"林业养护", phone:"18516205482" },
    //     {name:"奚晓萍", loginId:"13816746319", userId:randomId("13816746319"), pwd:getPwdMd5("13816746319", md5PwdStr("746319")), position:"林业养护", phone:"13816746319" },
    // ];
    // await usersData.createManyUser(list);

    const Now = new Date().valueOf();

    
    //导入地块数据
    let diKuaiList =[
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.5, useSize:0, size:8.5, area:"A区域", name:"A-11#", code:"A-11#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:11.3, useSize:0, size:11.3, area:"A区域", name:"A-9#", code:"A-9#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:13.3, useSize:0, size:13.3, area:"A区域", name:"A-10#", code:"A-10#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:10.4, useSize:0, size:10.4, area:"A区域", name:"A-8#", code:"A-8#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.3, useSize:0, size:8.3, area:"A区域", name:"A-7#", code:"A-7#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:9.5, useSize:0, size:9.5, area:"A区域", name:"A-6#", code:"A-6#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:11.9, useSize:0, size:11.9, area:"A区域", name:"A-5#", code:"A-5#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:22, useSize:0, size:22, area:"A区域", name:"A-1#", code:"A-1#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:14.9, useSize:0, size:14.9, area:"A区域", name:"A-2#", code:"A-2#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:22.7, useSize:0, size:22.7, area:"A区域", name:"A-3#", code:"A-3#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:26.9, useSize:0, size:26.9, area:"A区域", name:"A-4#", code:"A-4#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.2, useSize:0, size:8.2, area:"B区域", name:"B-1#", code:"B-1#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:5.8, useSize:0, size:5.8, area:"B区域", name:"B-2#", code:"B-2#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:5.2, useSize:0, size:5.2, area:"B区域", name:"B-3#", code:"B-3#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:2.8, useSize:0, size:2.8, area:"B区域", name:"B-14#", code:"B-14#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.5, useSize:0, size:6.5, area:"B区域", name:"B-10#", code:"B-10#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:10, useSize:0, size:10, area:"B区域", name:"B-4#", code:"B-4#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:10, useSize:0, size:10, area:"B区域", name:"B-5#", code:"B-5#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3.4, useSize:0, size:3.4, area:"B区域", name:"B-9#", code:"B-9#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3.4, useSize:0, size:3.4, area:"B区域", name:"B-8#", code:"B-8#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3, useSize:0, size:3, area:"B区域", name:"B-7#", code:"B-7#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3, useSize:0, size:3, area:"B区域", name:"B-6#", code:"B-6#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:4.1, useSize:0, size:4.15, area:"B区域", name:"B-11#", code:"B-11#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:4.1, useSize:0, size:4.1, area:"B区域", name:"B-12#", code:"B-12#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.1, useSize:0, size:8.1, area:"B区域", name:"B-13#", code:"B-13#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3.6, useSize:0, size:3.6, area:"B区域", name:"B-15#", code:"B-15#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:2.5, useSize:0, size:2.5, area:"B区域", name:"B-16#", code:"B-16#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:13.6, useSize:0, size:13.6, area:"C区域", name:"C-3#", code:"C-3#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.2, useSize:0, size:8.2, area:"C区域", name:"C-2#", code:"C-2#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.5, useSize:0, size:8.5, area:"C区域", name:"C-1#", code:"C-1#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:10.4, useSize:0, size:10.4, area:"D区域", name:"D-1#", code:"D-1#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:8.7, useSize:0, size:8.7, area:"D区域", name:"D-2#", code:"D-2#"},
        
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.2, useSize:0, size:6.2, area:"D区域", name:"D-A-02#", code:"D-A-02#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:5.2, useSize:0, size:5.2, area:"D区域", name:"D-A-03#", code:"D-A-03#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:10.4, useSize:0, size:10.4, area:"D区域", name:"D-B-01#", code:"D-B-01#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:3.4, useSize:0, size:3.4, area:"D区域", name:"D-B-02#", code:"D-B-02#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.2, useSize:0, size:6.2, area:"D区域", name:"D-C-01#", code:"D-C-01#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.2, useSize:0, size:6.2, area:"D区域", name:"D-C-02#", code:"D-C-02#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.6, useSize:0, size:6.6, area:"D区域", name:"D-C-03#", code:"D-C-03#"},
        { dId:randomId(TABLENAME.地块表), ct : Now, createUser:"admin", purpose:PURPOSE.菜田, plotType:PLOTTYPE.地块, nullSize:6.6, useSize:0, size:6.6, area:"D区域", name:"D-C-04#", code:"D-C-04#"},
        //养殖池
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:100, useSize:0, size:100, area:"A区域", name:"A-01#", code:"A-01#"},
    ];

    let 校验面积Map = {};
    let diKuaiMap = {}
    diKuaiList.forEach(info => {
        diKuaiMap[info.name] = info.dId;
        校验面积Map[info.name] = info.size;
    });

    await dikuaiData.addManyData(diKuaiList);
    //导入地块成功

    
    // 导入种植数据
    let zhongzhiDataList = [
        {dId:diKuaiMap["A-10#"],  plantType:SHUCAI.黄瓜, zId:randomId(TABLENAME.种植表), code:"A-10#", size:2, plantTime:new Date("2024-12-5 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-3#"],  plantType:SHUCAI.草莓, zId:randomId(TABLENAME.种植表), code:"A-3#", size:0.5, plantTime:new Date("2024-9-4 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-10#"],  plantType:SHUCAI.莴笋, zId:randomId(TABLENAME.种植表), code:"A-10#", size:3.5, plantTime:new Date("2024-11-30 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-10#"],  plantType:SHUCAI.小番茄, zId:randomId(TABLENAME.种植表), code:"A-10#", size:5, plantTime:new Date("2024-12-5 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-6#"],  plantType:SHUCAI.萝卜, zId:randomId(TABLENAME.种植表), code:"B-6#", size:2, plantTime:new Date("2024-10-28 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-4#"],  plantType:SHUCAI.青菜, zId:randomId(TABLENAME.种植表), code:"B-4#", size:10, plantTime:new Date("2025-1-21 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-3#"],  plantType:SHUCAI.大白菜, zId:randomId(TABLENAME.种植表), code:"B-3#", size:2, plantTime:new Date("2024-10-27 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-10#"],  plantType:SHUCAI.红菜苔, zId:randomId(TABLENAME.种植表), code:"B-10#", size:1, plantTime:new Date("2024-10-10 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-11#"],  plantType:SHUCAI.杭白菜, zId:randomId(TABLENAME.种植表), code:"B-11#", size:1, plantTime:new Date("2025-1-19 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-8#"],  plantType:SHUCAI.球生菜, zId:randomId(TABLENAME.种植表), code:"A-8#", size:10, plantTime:new Date("2024-11-15 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-9#"],  plantType:SHUCAI.球生菜, zId:randomId(TABLENAME.种植表), code:"A-9#", size:5, plantTime:new Date("2024-11-15 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["A-11#"],  plantType:SHUCAI.球生菜, zId:randomId(TABLENAME.种植表), code:"A-11#", size:5, plantTime:new Date("2024-11-15 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-2#"],  plantType:SHUCAI.球生菜, zId:randomId(TABLENAME.种植表), code:"B-2#", size:5, plantTime:new Date("2024-11-21 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-5#"],  plantType:SHUCAI.球生菜, zId:randomId(TABLENAME.种植表), code:"B-5#", size:5, plantTime:new Date("2024-11-21 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-4#"],  plantType:SHUCAI.黄心菜, zId:randomId(TABLENAME.种植表), code:"B-4#", size:1, plantTime:new Date("2024-11-7 00:00:00").valueOf(), uId:"admin", isEnd:0},
       
        {dId:diKuaiMap["B-2#"], plantType:SHUCAI.米苋, zId:randomId(TABLENAME.种植表), code:"B-2#", size:1, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-2#"], plantType:SHUCAI.鸡毛菜, zId:randomId(TABLENAME.种植表), code:"B-2#", size:0.5, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-2#"], plantType:SHUCAI.青菜, zId:randomId(TABLENAME.种植表), code:"B-2#", size:2, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-2#"], plantType:SHUCAI.杭白菜, zId:randomId(TABLENAME.种植表), code:"B-2#", size:0.5, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-4#"], plantType:SHUCAI.杭白菜, zId:randomId(TABLENAME.种植表), code:"B-4#", size:0.5, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-4#"], plantType:SHUCAI.青菜, zId:randomId(TABLENAME.种植表), code:"B-4#", size:1.5, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-2#"], plantType:SHUCAI.玉米, zId:randomId(TABLENAME.种植表), code:"B-2#", size:1, plantTime:new Date("2025-4-12 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["B-6#"], plantType:SHUCAI.玉米, zId:randomId(TABLENAME.种植表), code:"B-6#", size:0.5, plantTime:new Date("2025-4-13 00:00:00").valueOf(), uId:"admin", isEnd:0},

        {dId:diKuaiMap["D-A-02#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-A-02#", size:6.2, plantTime:new Date("2024-10-8 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-A-03#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-A-03#", size:5.2, plantTime:new Date("2024-9-26 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-B-01#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-B-01#", size:10.4, plantTime:new Date("2024-10-11 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-B-02#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-B-02#", size:3.4, plantTime:new Date("2024-10-13 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-C-01#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-C-01#", size:6.2, plantTime:new Date("2024-10-15 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-C-02#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-C-02#", size:6.2, plantTime:new Date("2024-10-8 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-C-03#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-C-03#", size:6.6, plantTime:new Date("2024-10-9 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-C-04#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-C-04#", size:6.6, plantTime:new Date("2024-10-9 00:00:00").valueOf(), uId:"admin", isEnd:0},

        {dId:diKuaiMap["D-1#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-1#", size:6.9, plantTime:new Date("2024-10-20 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["D-2#"], plantType:SHUCAI.番茄, zId:randomId(TABLENAME.种植表), code:"D-2#", size:5.7, plantTime:new Date("2024-10-19 00:00:00").valueOf(), uId:"admin", isEnd:0},

        
    ];

    
    for (let i= 0; i < zhongzhiDataList.length; i++) {
        let {dId, size, code} = zhongzhiDataList[i];
        let diKuaiInfo = await dikuaiData.selectOne({dId});

        if (!diKuaiInfo) {
            console.log("锚点1   地块不存在", dId, code);
        }
        else {
            diKuaiInfo.nullSize = diKuaiInfo.size - size;
            diKuaiInfo.useSize = diKuaiInfo.useSize + size;
        }

        await diKuaiInfo.save();
        await zhongzhiData.addData(zhongzhiDataList[i]);

       
    }

    //校验种植面积

    let 校验种养map = {};
    let 种养面积 = {};
    let countMap= {};
    for (let i= 0; i < zhongzhiDataList.length; i++) {
        let {code, size, plantType} = zhongzhiDataList[i];
        if (!种养面积[code]) 种养面积[code] = 0;
        种养面积[code] += size;
        if (!countMap[`${code}_${plantType}`]) countMap[`${code}_${plantType}`] = 0;
        countMap[`${code}_${plantType}`] += 1;
    }
    for (let code in 种养面积) {
        let size = 种养面积[code];
        if (校验面积Map[code].size < size) console.log(code, "种植面积", size ,"大于", 校验面积Map[code].size);
    }
    for (let i= 0; i < zhongzhiDataList.length; i++) {
        let {code, size, zId, plantType} = zhongzhiDataList[i];
        if (!校验面积Map[code]) console.log("codeId不对", code);
        校验种养map[`${code}_${plantType}`] = zId;
    }

    let caiShouList = [
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.黄瓜, code:"A-10#", dIdList:["A-10#"], weight:3780, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.草莓, code:"A-3#", dIdList:["A-3#"], weight:125, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.莴笋, code:"A-10#", dIdList:["A-10#"], weight:1220, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.小番茄, code:"A-10#", dIdList:["A-10#"], weight:465, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.萝卜, code:"B-6#", dIdList:["B-6#"], weight:1370, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.青菜, code:"B-4#", dIdList:["B-4#"], weight:21420, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.大白菜, code:"B-3#", dIdList:["B-3#"], weight:4200, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.红菜苔, code:"B-10#", dIdList:["B-10#"], weight:110, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.杭白菜, code:"B-11#", dIdList:["B-11#"], weight:800, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.球生菜, code:"A-8#", dIdList:["A-8#"], weight:15000, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.球生菜, code:"A-9#", dIdList:["A-9#"], weight:7500, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.球生菜, code:"A-11#", dIdList:["A-11#"], weight:7500, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.球生菜, code:"B-5#", dIdList:["B-5#"], weight:15065, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.球生菜, code:"B-2#", dIdList:["B-2#"], weight:15065, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.黄心菜, code:"B-4#", dIdList:["B-4#"], weight:240, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"A-02#", dIdList:["A-02#"], weight:8000, operationTime:new Date("2024-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-A-02#", dIdList:["D-A-02#"], weight:2500, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-A-03#", dIdList:["D-A-03#"], weight:1200, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-B-01#", dIdList:["D-B-01#"], weight:5000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-B-02#", dIdList:["D-B-02#"], weight:1200, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-C-01#", dIdList:["D-C-01#"], weight:3000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-C-02#", dIdList:["D-C-02#"], weight:3000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-C-03#", dIdList:["D-C-03#"], weight:4500, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-C-04#", dIdList:["D-C-04#"], weight:4000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-1#", dIdList:["D-1#"], weight:3000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"D-2#", dIdList:["D-2#"], weight:2000, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.牛心菜, code:"B-12#", dIdList:["B-12#"], weight:250, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.青菜, code:"B-4#", dIdList:["B-4#"], weight: 755, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.青菜, code:"B-1#", dIdList:["B-1#"], weight:1510, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.鸡毛菜, code:"B-6#", dIdList:["B-6#"], weight: 215, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.鸡毛菜, code:"B-1#", dIdList:["B-1#"], weight:215, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.鸡毛菜, code:"A-8#", dIdList:["A-8#"], weight:60, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.草莓, code:"A-3#", dIdList:["A-3#"], weight:200, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"A-10#", dIdList:["A-10#"], weight:1700, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.番茄, code:"B-8#", dIdList:["B-8#"], weight:1700, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.生菜, code:"B-11#", dIdList:["B-11#"], weight:620, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.杭白菜, code:"B-4#", dIdList:["B-4#"], weight: 365, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.杭白菜, code:"B-1#", dIdList:["B-1#"], weight:365, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.茼蒿, code:"A-8#", dIdList:["A-8#"], weight:60, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {csId:randomId(TABLENAME.采收), plantType:SHUCAI.茼蒿, code:"B-12#", dIdList:["B-12#"], weight:380, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
    ];

    let addCaiShouList = [];
    let 映射Map = {};

    for (let i= 0; i < caiShouList.length; i++) {
        let {code, plantType} = caiShouList[i];
        
        if (!校验种养map[`${code}_${plantType}`]) console.log(code, "种类：", changeEnumValue(SHUCAI, plantType) ,"无效");
        else {
            addCaiShouList.push(caiShouList[i]);
            映射Map[`${code}_${plantType}`] = 校验种养map[`${code}_${plantType}`];
        }
    }

    for (let i= 0; i < addCaiShouList.length; i++) {
        let {dIdList, size, code, plantType, csId} = addCaiShouList[i];
        let zId = 映射Map[`${code}_${plantType}`];

        let zhongzhiInfo = await zhongzhiData.selectOne({zId, isEnd:0});
        if (zhongzhiInfo) {
            zhongzhiInfo.csId = csId;
            countMap[`${code}_${plantType}`] -= 1;
            if (countMap[`${code}_${plantType}`] <= 0) {
                zhongzhiInfo.isEnd = 1;
            }
            await zhongzhiInfo.save();

            let diKuaiInfo = await dikuaiData.selectOne({code});
            if (!diKuaiInfo) console.log("锚点2   地块不存在", code);
            else {
                diKuaiInfo.nullSize = diKuaiInfo.nullSize + zhongzhiInfo.size;
                diKuaiInfo.useSize = diKuaiInfo.useSize - zhongzhiInfo.size;
            }
            await diKuaiInfo.save();
        }
        
        await caishouData.addData(addCaiShouList[i]);
    }

    let xiaoshouList = [
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.黄瓜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:3780, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.草莓, quXiang:XIAOSHOUQUXIANG.田头销售, weight:125, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.莴笋, quXiang:XIAOSHOUQUXIANG.田头销售, weight:1220, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.小番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:465, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.萝卜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:1370, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.青菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:21420, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.大白菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:4200, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.红菜苔, quXiang:XIAOSHOUQUXIANG.田头销售, weight:110, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.杭白菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:800, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.球生菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:30000, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.球生菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:15065, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.黄心菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:240, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:8000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:2500, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:1200, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:5000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:1200, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:4500, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:4000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:2000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.牛心菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:250, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.青菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:1510, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.鸡毛菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:490, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.草莓, quXiang:XIAOSHOUQUXIANG.田头销售, weight:200, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.番茄, quXiang:XIAOSHOUQUXIANG.田头销售, weight:3400, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.生菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:620, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.杭白菜, quXiang:XIAOSHOUQUXIANG.田头销售, weight:730, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.茼蒿, quXiang:XIAOSHOUQUXIANG.田头销售, weight:440, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},
    ]

    await xiaoshouData.addManyData(xiaoshouList);

    let nongshi = [
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-4#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-4#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-4#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-4#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-2#"]], operationTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["B-6#"]], operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["A-1#"]], operationTime:new Date("2025-1-5 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["A-2#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-A-02#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-A-03#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-B-01#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-B-02#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-C-01#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-C-02#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-C-03#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-C-04#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-1#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nsId:randomId(TABLENAME.农事), nsType:NONGSHITYPE.灌溉, dIdList:[diKuaiMap["D-2#"]], operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
    ];

    await nongshiData.addManyData(nongshi);


    let nongziList = [	
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["A-2#"]], plantType:SHUCAI.番茄, count:30, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-A-2#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-A-3#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-B-1#"]], plantType:SHUCAI.番茄, count:40, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-C-2#"]], plantType:SHUCAI.番茄, count:15, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-C-1#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-C-2#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-C-3#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-C-4#"]], plantType:SHUCAI.番茄, count:20, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-1#"]], plantType:SHUCAI.番茄, count:35, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["D-2#"]], plantType:SHUCAI.番茄, count:30, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥,dIdList:[diKuaiMap["B-4#"]], plantType:SHUCAI.杭白菜, count:10, useTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥,dIdList:[diKuaiMap["B-4#"]], plantType:SHUCAI.青菜, count:30, useTime:new Date("2025-4-12 00:00:00").valueOf(),ct:Now},	
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.追肥保果素,dIdList:[diKuaiMap["B-7#"]], plantType:SHUCAI.番茄, count:2, useTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.银法利,dIdList:[diKuaiMap["B-1#"]], plantType:SHUCAI.番茄, count:150, useTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.银法利,dIdList:[diKuaiMap["B-5#"]], plantType:SHUCAI.番茄, count:150, useTime:new Date("2025-4-12 00:00:00").valueOf(), ct:Now},
        {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.农药,dIdList:[diKuaiMap["A-10#"]], plantType:SHUCAI.小番茄, count:108, useTime:new Date("2025-2-23 00:00:00").valueOf(), ct:Now}
    ]

    await nongziData.addManyData(nongziList);

    console.log("数据导入成功");

}


export async function dataInit0508() {
    const Now = new Date().valueOf();
    //导入地块数据
    let diKuaiList =[
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"水泥池", code:"水泥池"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"8号塘", code:"8号塘"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"7号塘", code:"7号塘"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"9号塘", code:"9号塘"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"14号塘", code:"14号塘"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"6号塘", code:"6号塘"},
        { dId:randomId(TABLENAME.地块表), ct : Now, creatUser:"admin", purpose:PURPOSE.养殖, plotType:PLOTTYPE.养殖池, nullSize:0, useSize:0, size:10, area:"水产", name:"10号塘", code:"10号塘"},
    ];
    dikuaiData.addManyData(diKuaiList);

    //种养
    let diKuaiMap = {}
    diKuaiList.forEach(info => {
        diKuaiMap[info.name] = info.dId;
    });
    
    let zhongzhiDataList = [
        {dId:diKuaiMap["水泥池"], plantType:PLANTTYPE.鳜鱼, zId:randomId(TABLENAME.种植表), code:"水泥池", size:30, plantTime:new Date("2024-5-2 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["8号塘"], plantType:PLANTTYPE.花䱻, zId:randomId(TABLENAME.种植表), code:"8号塘", size:50, plantTime:new Date("2024-5-8 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["7号塘"], plantType:PLANTTYPE.黄颡鱼, zId:randomId(TABLENAME.种植表), code:"7号塘", size:50, plantTime:new Date("2024-5-10 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["11号塘"], plantType:PLANTTYPE.长吻鮠, zId:randomId(TABLENAME.种植表), code:"11号塘", size:20, plantTime:new Date("2024-5-11 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["7号塘"], plantType:PLANTTYPE.翘嘴鲌, zId:randomId(TABLENAME.种植表), code:"7号塘", size:100, plantTime:new Date("2024-5-14 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["9号塘"], plantType:PLANTTYPE.草鱼, zId:randomId(TABLENAME.种植表), code:"9号塘", size:3000, plantTime:new Date("2024-5-15 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["14号塘"], plantType:PLANTTYPE.白鲢, zId:randomId(TABLENAME.种植表), code:"14号塘", size:300, plantTime:new Date("2024-5-16 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["6号塘"], plantType:PLANTTYPE.青鱼, zId:randomId(TABLENAME.种植表), code:"6号塘", size:10, plantTime:new Date("2024-5-20 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["14号塘"], plantType:PLANTTYPE.花鲢, zId:randomId(TABLENAME.种植表), code:"14号塘", size:150, plantTime:new Date("2024-5-22 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["6号塘"], plantType:PLANTTYPE.鲤鱼, zId:randomId(TABLENAME.种植表), code:"6号塘", size:3800, plantTime:new Date("2024-5-25 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["水泥池"], plantType:PLANTTYPE.胭脂鱼, zId:randomId(TABLENAME.种植表), code:"水泥池", size:10, plantTime:new Date("2024-5-25 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["10号塘"], plantType:PLANTTYPE.鳊鱼, zId:randomId(TABLENAME.种植表), code:"10号塘", size:3000, plantTime:new Date("2024-5-26 00:00:00").valueOf(), uId:"admin", isEnd:0},
        {dId:diKuaiMap["14号塘"], plantType:PLANTTYPE.细鳞鲴, zId:randomId(TABLENAME.种植表), code:"14号塘", size:80, plantTime:new Date("2024-5-27 00:00:00").valueOf(), uId:"admin", isEnd:0},
    ];
    await zhongzhiData.addManyData(zhongzhiDataList);

    let xiaoshouList = [
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.细鳞鲴, quXiang:XIAOSHOUQUXIANG.本地, weight:34400, operationTime:new Date("2025-2-17 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.鳙鱼, quXiang:XIAOSHOUQUXIANG.本地, weight:240000, operationTime:new Date("2025-2-17 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.鲢鱼, quXiang:XIAOSHOUQUXIANG.本地, weight:600000, operationTime:new Date("2025-2-17 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.细鳞鲴, quXiang:XIAOSHOUQUXIANG.本地, weight:7500, operationTime:new Date("2025/2/21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.鳙鱼, quXiang:XIAOSHOUQUXIANG.本地, weight:22500, operationTime:new Date("2025/2/21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {xsId:randomId(TABLENAME.销售), plantType:PLANTTYPE.鲢鱼, quXiang:XIAOSHOUQUXIANG.本地, weight:19650, operationTime:new Date("2025/2/21 00:00:00").valueOf(), ct:Now, createUser:"admin"}
    ];
    await xiaoshouData.addManyData(xiaoshouList);
}

export async function yjDataInit0508() {
    const Now = new Date().valueOf();
    // return
    let zzList = [
        {plantType:PLANTTYPE.番茄, time:"2025-1-19 00:00:00", dId:"A-1#", size:16.4},
        {plantType:PLANTTYPE.番茄, time:"2024-11-16 00:00:00", dId:"A-2#", size:10},  	
        {plantType:PLANTTYPE.番茄, time:"2024-10-8 00:00:00", dId:"D-A-02#", size:6.2},
        {plantType:PLANTTYPE.番茄, time:"2024-9-26 00:00:00", dId:"D-A-03#", size:5.2},
        {plantType:PLANTTYPE.番茄, time:"2024-10-11 00:00:00", dId:"D-B-01#", size:10.4},
        {plantType:PLANTTYPE.番茄, time:"2024-10-13 00:00:00", dId:"D-B-02#", size:3.4},
        {plantType:PLANTTYPE.番茄, time:"2024-10-15 00:00:00", dId:"D-C-01#", size:6.2},
        {plantType:PLANTTYPE.番茄, time:"2024-10-9 00:00:00", dId:"D-C-03#", size:6.6},
        {plantType:PLANTTYPE.番茄, time:"2024-10-9 00:00:00", dId:"D-C-04#", size:6.6},
        {plantType:PLANTTYPE.番茄, time:"2024-10-20 00:00:00", dId:"D-1#", size:6.9},
        {plantType:PLANTTYPE.茼蒿, time:"2025-4-21 00:00:00", dId:"B-1#", size:0.5},
        {plantType:PLANTTYPE.红米苋, time:"2025-4-21 00:00:00", dId:"B-1#", size:0.5},
        {plantType:PLANTTYPE.生菜, time:"2025-4-22 00:00:00", dId:"B-1#", size:0.5},
        {plantType:PLANTTYPE.红米苋, time:"2025-4-26 00:00:00", dId:"B-5#", size:1},
        {plantType:PLANTTYPE.青菜, time:"2025-4-26 00:00:00", dId:"B-5#", size:1},
        {plantType:PLANTTYPE.鸡毛菜, time:"2025-4-26 00:00:00", dId:"B-5#", size:0.5},
        {plantType:PLANTTYPE.杭白菜, time:"2025-4-26 00:00:00", dId:"B-5#", size:0.5},
        {plantType:PLANTTYPE.青米苋, time:"2025-4-26 00:00:00", dId:"B-5#", size:0.5},
        {plantType:PLANTTYPE.紫青菜, time:"2025-4-26 00:00:00", dId:"B-5#", size:0.5},
        {plantType:PLANTTYPE.冬瓜, time:"2025-4-26 00:00:00", dId:"B-13#", size:3},
        {plantType:PLANTTYPE.南瓜, time:"2025-4-26 00:00:00", dId:"B-13#", size:2},
        {plantType:PLANTTYPE.红薯叶, time:"2025-4-26 00:00:00", dId:"B-10#", size:1},
    ]

    // {dId:diKuaiMap["A-10#"],  plantType:SHUCAI.黄瓜, zId:randomId(TABLENAME.种植表), code:"A-10#", size:2, plantTime:new Date("2024-12-5 00:00:00").valueOf(), uId:"admin", isEnd:0},


    let zzAddList = [];

    for (let i =0; i < zzList.length; i++) {
        let {plantType, size, time} = zzList[i];
        let item = zzList[i];
        let diKuaiInfo = await dikuaiData.selectOne({code:item.dId});
        if (!diKuaiInfo || !diKuaiInfo.dId) {
            console.log("地块不存在", );
            continue;
        }
        zzAddList.push({dId:item.dId, plantType, zId:randomId(TABLENAME.种植表), code:item.dId, size, plantTime:new Date(time).valueOf(), uId:"admin", isEnd:0});
    }
    await zhongzhiData.addManyData(zzAddList);

    // {csId:randomId(TABLENAME.采收), plantType:SHUCAI.黄瓜, code:"A-10#", dIdList:["A-10#"], weight:3780, operationTime:new Date("2024-2-1 00:00:00").valueOf(), ct:Now, createUser:"admin"},
    // {plantType:PLANTTYPE.番茄, time:"2025-4-7 00:00:00", weight:8000, code:"A-2#"},
    let csList = [
        {plantType:PLANTTYPE.番茄, time:"2025-4-7 00:00:00", weight:8000, code:"A-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:2500, code:"DA-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:1200, code:"DA-3#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:5000, code:"DB-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:1200, code:"DB-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:3000, code:"DC-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:3000, code:"DC-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:4500, code:"D-C-03#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:4000, code:"D-C-04#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:3000, code:"D1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-7 00:00:00", weight:2000, code:"D2#"},
        {plantType:PLANTTYPE.番茄, time:"2025-4-14 00:00:00", weight:7000, code:"A-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1500, code:"D-A-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1000, code:"D-A-3#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:2000, code:"D-B-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:800 , code:"D-B-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1000, code:"D-C-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:800 , code:"D-C-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1500, code:"D-C-03#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1500, code:"D-C-04#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:1000, code:"D1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-14 00:00:00", weight:800 , code:"D2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:500 , code:"A-1#"},
        {plantType:PLANTTYPE.番茄, time:"2025-4-21 00:00:00", weight:2000, code:"A-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1500, code:"D-A-02#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1000, code:"D-A-03#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1500, code:"D-B-01#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:800 , code:"D-B-02#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:500 , code:"D-C-01#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:400 , code:"D-C-02#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1000, code:"D-C-03#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1000, code:"D-C-04#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:1200, code:"D-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-21 00:00:00", weight:850 , code:"D-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:1000, code:"A-1#"},
        {plantType:PLANTTYPE.番茄, time:"2025-4-28 00:00:00", weight:400 , code:"A-2#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:1000, code:"D-A-02#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:860 , code:"D-A-03#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:1000, code:"D-B-01#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:400 , code:"D-B-02#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:1000, code:"D-1#"},
        {plantType:PLANTTYPE.小番茄, time:"2025-4-28 00:00:00", weight:400, code:"D-2#"},
    ];
    let csAddList = [];
    for (let i =0; i < csList.length; i++) {
        let {plantType, time, code ,weight} = csList[i];
        let item = zzList[i];
        let diKuaiInfo = await dikuaiData.selectOne({code});
        if (!diKuaiInfo || !diKuaiInfo.dId) {
            console.log("地块不存在", );
            continue;
        }
        let zzInfo = await zhongzhiData.selectOne({dId:diKuaiInfo.dId, plantType});
        if (zzInfo && zzInfo.zId) {
            zzInfo.isEnd = 1;
            await zzInfo.save();
        }
        csAddList.push({csId:randomId(TABLENAME.采收), plantType, code, dId:[diKuaiInfo.dId], weight, operationTime:new Date(time).valueOf(), ct:Now, createUser:"admin"});
    }
    await caishouData.addManyData(csAddList);

    // {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥,dIdList:[diKuaiMap["A-2#"]], plantType:SHUCAI.番茄, count:30, useTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now},
        
    // let nzList = [
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥, dId:		B1-7	叶菜	count:20, ct:Now,	useTime:new Date("2025-4-21 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥, dId:		B1-12	叶菜	count:20, ct:Now,	useTime:new Date("2025-4-21 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥, dId:		B1-13	叶菜	count:20, ct:Now,	useTime:new Date("2025-4-22 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥, dId:		B1-11	叶菜	count:20, ct:Now,	useTime:new Date("2025-4-22 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.复合肥, dId:		B10-2	红薯叶	count:20, ct:Now,	useTime:new Date("2025-4-26 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.追肥保果素, dId:	A8号	番茄	count:19, ct:Now,	useTime:new Date("2025-4-28 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.追肥保果素, dId:	B1号	番茄	count:19, ct:Now,	useTime:new Date("2025-4-28 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.追肥保果素, dId:	B5	番茄	count:19, ct:Now,	useTime:new Date("2025-4-28 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.追肥保果素, dId:	B7	番茄	count:19, ct:Now,	useTime:new Date("2025-4-28 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.好力克, dId:		A9号	黄瓜	count:168, ct:Now, 	useTime:new Date("2025-4-22 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.银法利, dId:		A9号	黄瓜	count:500, ct:Now, 	useTime:new Date("2025-4-22 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.啶虫脒, dId:		A9号	黄瓜	count:24, ct:Now,	useTime:new Date("2025-4-22 00:00:00").valueOf()}
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.有机肥, dId:A-01#	番茄			
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-02	番茄	30	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-2	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-3	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DB-1	番茄	40	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	15	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-1	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-3	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-4	番茄	20	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D1	番茄	35	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D2	番茄	30	kg	2025.4.7-4.13
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-02	番茄	30	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-2	番茄	20	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-3	番茄	20	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DB-1	番茄	40	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	10	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-1	番茄	20	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	20	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-3	番茄	30	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-4	番茄	30	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D1	番茄	0	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D2	番茄	0	kg	2025.4.14-4.20
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-01#	番茄	50	kg	2025.4.25
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-02	番茄	30	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-2	番茄	20	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-3	番茄	20	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DB-1	番茄	40	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	10	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-1	番茄	20	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	20	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-3	番茄	30	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-4	番茄	30	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D1	番茄	30	kg	2025.4.21-4.27
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D2	番茄	20	kg	2025.4.21-4.27		
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-01#	番茄		kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:A-02	番茄	30	kg	2025.4.28-5.4
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-2	番茄	20	kg	2025.4.28-5.4
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DA-3	番茄	20	kg	2025.4.28-5.4
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DB-1	番茄	40	kg	2025.4.28-5.4
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	10	kg	2025.4.28-5.4
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-1	番茄	0	kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-2	番茄	0	kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-3	番茄	0	kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:DC-4	番茄	0	kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D1	番茄		kg	
    //     {nzId:randomId(TABLENAME.农资), nzType:NONGZITYPE.水溶肥, dId:D2	番茄		kg	
    // ];
    
    // {xsId:randomId(TABLENAME.销售), plantType:SHUCAI.茼蒿, quXiang:XIAOSHOUQUXIANG.田头销售, weight:440, operationTime:new Date("2025-4-7 00:00:00").valueOf(), ct:Now, createUser:"admin"},

    let list = [
        {plantType:PLANTTYPE.青菜,quXiang:XIAOSHOUQUXIANG.本地, weight:1430, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.青菜,quXiang:XIAOSHOUQUXIANG.本地, weight:460, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.鸡毛菜,quXiang:XIAOSHOUQUXIANG.本地, weight:155, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.鸡毛菜,quXiang:XIAOSHOUQUXIANG.本地, weight:213, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.小番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1140, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.小番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1520, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:250, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:2300, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.杭白菜,quXiang:XIAOSHOUQUXIANG.本地, weight:80, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.杭白菜,quXiang:XIAOSHOUQUXIANG.本地, weight:300, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.蚕豆,quXiang:XIAOSHOUQUXIANG.本地, weight:235, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.樱桃萝卜,quXiang:XIAOSHOUQUXIANG.本地, weight:130, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.米苋,quXiang:XIAOSHOUQUXIANG.本地, weight:390, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.黄瓜,quXiang:XIAOSHOUQUXIANG.本地, weight:1245, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.菠菜,quXiang:XIAOSHOUQUXIANG.本地, weight:280, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.豆苗,quXiang:XIAOSHOUQUXIANG.本地, weight:10, operationTime:new Date("2025-4-27 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:8000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:2500, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1200, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:5000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1200, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:4500, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:4000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:3000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:2000, operationTime:new Date("2025-4-13 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:7000, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1500, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:2000, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:800, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:800, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1500, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1500, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:800, operationTime:new Date("2025-4-15 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:2000, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1500, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1500, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:800, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:800, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:400, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1200, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:850, operationTime:new Date("2025-4-21 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:400, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:850, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:400, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:1000, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
        {plantType:PLANTTYPE.番茄,quXiang:XIAOSHOUQUXIANG.本地, weight:400, operationTime:new Date("2025-4-28 00:00:00").valueOf(), ct:Now, createUser:"admin"},
    ];
    
    await xiaoshouData.addManyData(list);


    // console.log();
}
