/**
 * 采收逻辑
 */
import { TABLENAME } from "../config/dbEnum";
import { CaiShouConfig } from "../config/eccParam";
import { PLANTTYPE, ZHONGYANGTYPE } from "../config/enum";
import * as caishouData from "../data/caishou";
import * as dikuaiData from "../data/dikuai";
import * as zhongzhiData from "../data/zhongzhi";
import { randomId, successResult } from "../tools/system";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";
import moment = require("moment");


/**
 * 添加采收
 * @param reqUser 
 * @param param 
 * @returns 
 */
export async function addCaiShou(reqUser, param) {
    let funName = `添加采收`;
    eccFormParam(funName, CaiShouConfig, param );
    eccEnumValue(funName, "plantType", PLANTTYPE, param.plantType);
    
    //修改种养
    let zhongyangParam = {isEnd:0, plantType:param.plantType, dId:param.dId};
    let zhongzhiList = await zhongzhiData.selectToParam(zhongyangParam);

    let sizeCount = 0;
    for (let i = 0; i < zhongzhiList.length; i++) {
        let {dId, size} = zhongzhiList[i];
        sizeCount += size;
    }

    //释放地块
    let diKuaiInfo = await dikuaiData.selectOne({dId:param.dId});
    diKuaiInfo.nullSize = diKuaiInfo.nullSize + sizeCount;
    diKuaiInfo.useSize = diKuaiInfo.useSize - sizeCount;
    await diKuaiInfo.save();

    let  csId = randomId(TABLENAME.采收);
    //改变种植面积
    await zhongzhiData.updateManyToParam({isEnd:0, plantType:param.plantType}, {isEnd:1, csId});

    //添加采收记录
    let addInfo = {
        csId,
        dIdList:param.dIdList,
        plantType:param.plantType,
        operationTime:param.operationTime,
        weight:param.weight,
        ct:new Date().valueOf(),
        createUser:reqUser.userId
    };
    await caishouData.addData(addInfo)

    return successResult();
}



/**
 * 采收列表
 * @param selectStr 
 * @param dId 
 * @param zhongYangType 
 * @param plantType 
 * @param operationTime 
 * @returns 
 */
export async function caiShouList(zhongYangType:number, selectStr:string, dId:string, plantType:number, operationTime:number) {
    let funName = "采收列表";
    eccEnumValue(funName, "zhongYangType", ZHONGYANGTYPE, zhongYangType);

    let param:any = { plantType : {"$gte":zhongYangType, "$lt":zhongYangType+99} };
    if (plantType) {
        eccEnumValue(funName, "plantType", PLANTTYPE, plantType);
        param.plantType = plantType;
    }
    if (dId) {
        param.dIdList = {"$in":dId};
    }
    if (operationTime) {
        let startMs = moment(operationTime).startOf("month").valueOf();
        let endMs = moment(operationTime).endOf("month").valueOf();
        param.useTime = {"$gt":startMs, "$lt":endMs};
    }

    let dikuaiList = await dikuaiData.selectToParam({});
    let diKuaiMap = {};
    dikuaiList.forEach(info => {
        let {dId, code} = info;
        diKuaiMap[dId] = code;
    });

    let nongShiList = await caishouData.selectToParam(param);
    let dataList = [];
    nongShiList.forEach(item => {
        let {plantType, dIdList, operationTime, weight } = item;
        let dIds = dIdList;
        let didStr = "";
        dIds.forEach(dId => {
            didStr += `${dId} `;
        });
        dataList.push({
            plantType:changeEnumValue(PLANTTYPE, plantType),
            dIdList:didStr,
            operationTime:moment(operationTime).format("YYYY-MM-DD"),
            weight
        });
    });

    return {dataList}
}