
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function yzdqxdnyzlTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('zjny.xlsx', '现代农业走廊');

    let keyValueOrTitleList = ["张江镇自然资源","水资源利用率","企业情况","总体数据分布","专业员工类型","从业人员情况","产业结构","产业主体结构",
    "重点项目建设","项目分析","专家服务","技术创新引进情况","创新技术基础数据","引进技术基础数据","经营管理情况"];//适配 饼图 键值以及需要多个key的

    let barChartList = ["技术创新趋势","引进技术创新趋势","农业生产产值趋势图"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = [];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}