/**
 * 
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function guangfuTableData() {
    let blockDataList = onceSheetBecomeOfblockData('光伏.xlsx', 'Sheet1');

    let keyValueOrTitleList = ['投入使用', '投入使用趋势', '效益分析', '节能减排']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}



export function jiQiRenTableData() {
    let blockDataList = onceSheetBecomeOfblockData('机器人.xlsx', 'Sheet1');

    let keyValueOrTitleList = ['机器人类型占比', '运行状态', '顶部指标']; //适配 饼图 键值以及需要多个Key的
    let barChartList = ['巡检设备类型', '巡检趋势', '运行趋势分析', '区域布局', '智能机器人产量']; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['运行记录', '巡检记录']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}




