export enum ERRORENUM {
    未找到数据,
    数据操作失败,
    暂无对应数据,
    文件不存在,
    参数错误,
    地址数据不完整,
    请完善信息,
    接口数据获取失败
}


export enum SYSTEMERRORENUM {
    参数错误 = 1,
    您的登录已失效,
    您的账户没有访问权限,
    请求参数错误,
    文件解析失败,
    文件写入失败,
    获取企业微信access_token失败,
    获取企业微信用户信息失败,
    请先绑定用户,
    TOKEN失效,
    该微信用户已绑定过账号,
    存在TOKEN并没有绑定角色,
    初始化配置失败,
    暂无对应数据
}


export enum INTERFACEERRORENUM {
    "系统错误" = 10001,
    "电站不存在" = 10002,
    "电站ID为空" = 10003,
    "时间格式不正确" = 10004,
    "没有权限访问" = 10011,
    "访问频率限制5分钟/次" = 10012,
    "页数超过100" = 10013,
    "页数不能大于250页" = 10014,
}


let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

let systemErrorMsgMap = {};
for (let key in SYSTEMERRORENUM) {
    systemErrorMsgMap[SYSTEMERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}

export function getSysMsg(param) {
    return systemErrorMsgMap[param];
}