/**
 * 左屏
 */

import { getGuangFu } from "../data/interface/dataInterface";
import { getKeyValueOut, getOnceYBarChartOut } from "../dataPackage/out";
import { get } from "../util/request";


let guangfuData = {
    jbqk: [
    ],
    nhfx: {
      count: [
        {
          key: "年用电量",
          value: 0,
        },
        {
          key: "光伏发电量",
          value: "61312.7",
        },
      ],
      charData: [
      ],
      dayData: [
      ],
    },
    trsy: {
      count: [
        {
          key: "光伏投入成本",
          value: "123",
        },
        {
          key: "运维成本",
          value: "123",
        },
        {
          key: "发电量",
          value: "61312.7",
        },
        {
          key: "发电时长",
          value: 0,
        },
      ],
      charData: [
        {
          key: "2016",
          value: "518",
        },
        {
          key: "2017",
          value: "733",
        },
        {
          key: "2018",
          value: "116",
        },
        {
          key: "2019",
          value: "634",
        },
        {
          key: "2020",
          value: "116",
        },
        {
          key: "2021",
          value: "634",
        },
      ],
    },
    ztsj: [
      {
        key: "装机容量",
        value: 46,
      },
      {
        key: "总发电量",
        value: "61312.7",
      },
      {
        key: "实时功率",
        value: 13.800000190734863,
      },
    ],
    xyfxfd: {
      count: [
      ],
      chartData: [
      ],
    },
    xyfx: {
      count: [
        {
          key: "今日收益",
          value: 113.52,
        },
        {
          key: "当月收益",
          value: 2008.74,
        },
        {
          key: "累计收益",
          value: "123",
        },
      ],
      chartData: {
        "今年": [
        ],
        "去年": [
        ],
      },
    },
    jnjp: {
      count: [
        {
          key: "二氧化碳",
          value: "832克/千瓦时",
        },
        {
          key: "氮氧化物",
          value: "0.179克/千瓦时",
        },
        {
          key: "二氧化硫",
          value: "0.16克/千瓦时",
        },
        {
          key: "电力烟尘",
          value: "0.032克/千瓦时",
        }
      ],
      chartData: [
      ],
    },
  };
/**
 * 初始化接口数据
 */
export async function guangfuInit() {
    await getGuangFu();
    console.log();
}


/**
 * 左屏
 * @param req 
 * @param res 
 */
export async function getLeft(req, res) {
    let ret:any = {};

    ret['jbqk'] = getKeyValueOut('基本情况', guangfuData.jbqk);

    ret['fdglpjzfx'] = getKeyValueOut('能耗分析', guangfuData.nhfx.count);
    ret['fdglpjzfxqst'] = getKeyValueOut('发电功率平均值分析趋势图', guangfuData.nhfx.charData);
    ret['fdgldtgl'] = getKeyValueOut('发电功率当天分析', guangfuData.nhfx.dayData)
    
    ret['trsy'] = getKeyValueOut('投入使用', guangfuData.trsy.count);
    ret['trsyqst'] = getKeyValueOut('投入使用趋势', guangfuData.trsy.charData);

    res.send(ret);
}


/**
 * 中间
 * @param req 
 * @param res 
 */
export async function getData(req, res) {
    let ret:any = {};
    
    ret['ztsj'] = getKeyValueOut('整体数据', guangfuData.ztsj);
    //source=pc&weather_type=observe&province=上海&city=上海&county=浦东新区
    let query = {
      source:"pc",
      weather_type:"observe",
      province:"上海",
      city:"上海",
      county:"浦东新区"
    }
    let weatherData:any = await get("https://wis.qq.com/weather/common", query);
    let weather = {
      "天气":"",
      "温度":"",
      "风向":"",
      "风力等级":"",
      "湿度":"",
      "降水量":"",
      "图片":""
    }
    if(weatherData) {
      let observe = weatherData.body.data.observe;
      weather = {
        "天气":observe.weather,
        "温度":observe.degree,
        "风向":observe.wind_direction_name,
        "风力等级":observe.wind_power,
        "湿度":observe.humidity,
        "降水量":observe.precipitation,
        "图片":``
      }
    }
    ret['weather'] = {title:"天气", dataList:weather};

    res.send(ret);
}


/**
 * 右屏
 * @param req 
 * @param res 
 */
export async function getRight(req, res) {
    let ret:any = {};
    
    ret['xyfxfd'] = getKeyValueOut('效益分析-发电量', guangfuData.xyfxfd.count);
    ret['xyfxfdqst'] = getKeyValueOut('效益分析-发电量趋势', guangfuData.xyfxfd.chartData);

    ret['xyfx'] = getKeyValueOut('效益分析', guangfuData.xyfx.count);
     ret['xyfxqst'] = {title:"效益分析趋势", dataList:guangfuData.xyfx.chartData}

    ret['jnjp'] = getKeyValueOut('节能减排', guangfuData.jnjp.count);
    ret['jnjpqst'] = getKeyValueOut('节能减排趋势', guangfuData.jnjp.chartData);

    res.send(ret);
}









