
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function jdaqglTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('zjny.xlsx', '基地安全管理');

    let keyValueOrTitleList = ["设备类型占比","设备数量","设备状态情况","消防设备","消防设备状态","基地安全管理数据分析","天气数据","设备运行监测","警告次数",
        "紧急程度","预警处置","预警处置率"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["近七天设备在线情况","告警趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["正常状态列表","维护中状态列表","故障状态列表","预警处置表","重点区域监控"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}